#ifndef SYNCOBJ_H_
#define SYNCOBJ_H_

#include <vector>
#include <set>

#include "Process.h"
#include "memObject.h"

class Process;

/**
** Synchronizacny objekt. 
*/
class SyncObj {
private:
	std::set<Process *> processes;
	SyncObj* parent;
	SyncObj* childTrue;
	SyncObj* childFalse;
public:
	SyncObj(SyncObj* parent = NULL);
	virtual ~SyncObj();
	void addProcess(Process* process);
	void removeProcess(Process* process);
	void remove();
	bool canWakeUp();
	void removeChild(SyncObj* child);
	SyncObj* trueChild();
	SyncObj* falseChild();
	bool empty();
	SyncObj* getParent();
	std::set<Process *>& getProcesses();
};

#endif /* SYNCOBJ_H_ */
