#ifndef CODEOBJECT_H_
#define CODEOBJECT_H_

#include "symboltable.h"
#include "memory.h"

enum Instructions {RET, SYS, CALL, PARDO,
	LOAD_CONST, LOAD_LOC, LOAD_SHARE,
	STORE_LOC,  STORE_SHARE, POP, 
	STORE_ARR_LOC, STORE_ARR_GLOB, STORE_ARR_SHARE,
	JMP, JMPFALSE, JMPTRUE,
	ADD, SUB, MUL, DIV, SHL, SHR, AND, OR, XOR, LAND, LOR, NOT, 
	EQ, LESS, GRT, LEQ, GEQ,
	SIZEOF, SETP,
	DEREF, NEW, DELETE,
	SYNC, JMPFALSE_SYNC, SYNC_BEGIN};
enum SysCalls {READ, WRITE_};

typedef unsigned int ArgumentType;
typedef std::pair<Instructions, ArgumentType> InstrPair;
const int noArgument = 0;

/**
** Trieda reprezentujuca jeden kodovy celok, jednu funkciu. Okrem svojho kodu obsahuje tabulku
** symbolov pre lokalne premenne.
*/
class CodeObject {
private:
	std::string name;
	SymbolTable locals;
	std::vector<InstrPair> code;
	unsigned int numArgs;
	std::vector<std::string> pardoArgs;
	bool parallel;
	unsigned int syncDepth; // kolko urovni syncov mame za sebou (pocas generovania kodu)
	void adjustSyncDepth(Instructions instr);
public:
	CodeObject(std::string name, unsigned int numArgs, bool parallel = false);
	std::string getName();

	void addInstruction(InstrPair instruction);
	int reserveInstruction(Instructions JMPType);
	void backPatch(int address);
	int getCurrentAddress();

	int addLocal(std::string name, VarType varType) throw(symbolTableException);
	int getLocalAddress(std::string name) throw(symbolTableException);

	std::string dump();
	InstrPair getInstructionAt(unsigned int position);
	unsigned int getInstructionCount();
	unsigned int getNumArgs();

	memory* getMemory();

	int  addPardoArg(std::string name);
	std::vector<std::string> getPardoArgs();
	unsigned int getPardoArgCount();
	bool isParallel();
};


#endif /* CODEOBJECT_H_ */
