#ifndef CONTEXT_H
#define CONTEXT_H

#include "symboltable.h"
#include "codeobject.h"
#include "syntaxtree.h"

#include <sstream>

typedef std::pair<int, IDNamespace> addrAndNamespace;

class Context {
private:
	SymbolTable &share;
	SymbolTable &functions;
	std::vector<CodeObject *> &codeObjects;
	unsigned int activeCodeObject;
	SyntaxTreeNode *rootNode;
	unsigned int currentPardoFunction; //pocitadlo pre meno pardo funkcii

	int newCodeObject(std::string name, unsigned int argCount, bool parallel);
public:
	Context(SymbolTable &share, SymbolTable &functions, std::vector<CodeObject *> &codeObjects);
	void addSyntaxtTreeRoot(SyntaxTreeNode *root);
	void generateCode();

	int addLocal(std::string name, VarType varType);
	int addShared(std::string name, VarType varType);

	addrAndNamespace getAddress(std::string name) throw (symbolTableException);

	int addFunction(std::string name, VarType varType, unsigned int argCount, bool parallel = false) throw(symbolTableException);
	int getFunction(std::string name) throw (symbolTableException);
	void switchToFunction(std::string name) throw (symbolTableException);
	std::string getCurrentFunction();
	int addPardoFunction();
	unsigned int getNumArgs(std::string name); 

	void addInstruction(Instructions instruction, ArgumentType argument);
	int reserveInstruction(Instructions JMPType);
	void backPatch(int address);
	int getCurrentAddress();

	int addPardoArg(std::string name);
	std::vector<std::string> getPardoArgs();

	bool isInParProcedure();

	void freeSyntaxTree();
};

#endif
