#include "symboltable.h"

SymbolTable::SymbolTable(): next(0) {}

int SymbolTable::getValue(int index) throw(symbolTableException) {
	if (index >= next) {
		throw symbolTableException("ID not defined");
	}
	return table[index];
}

int SymbolTable::getIndex(std::string name) throw(symbolTableException) {
	std::map<std::string, std::pair<int, VarType> >::iterator it = names.find(name);
	if (it == names.end()) {
		throw symbolTableException("Name not defined: " + name);
	}
	return it->second.first;
}

int SymbolTable::addName(std::string name, VarType type) {
	names[name] = std::make_pair(next, type);
	return next++;
}

int SymbolTable::addNameWithValue(std::string name, int value, VarType type) throw(symbolTableException) {
	std::map<std::string, std::pair<int, VarType> >::iterator it = names.find(name);
	if (it != names.end()) {
		throw symbolTableException("Name already defined: " + name);
	}
	names[name] = std::make_pair(value, type);
	return value;
}

memory* SymbolTable::getMemory() {
	std::vector<memObject *>* memArr = new std::vector<memObject *>(names.size());
	std::map<std::string, std::pair<int, VarType> >::iterator it = names.begin();
	while (it != names.end()) {
		std::pair<int, VarType> pair = it->second;
		switch (pair.second) {
			case v_int: (*memArr)[pair.first] = new memInteger(0, it->first); break;
			case v_arr: (*memArr)[pair.first] = new memArray(it->first); break;
		}

		it++;
	}
	return new memory(memArr);
}
