#include "pari.h"
#include <sys/time.h>

int main(int argc, char **argv)
{
	if (argc == 1) {
		printf("Zadaj hodnotu n\n");
		return 1;
	}

	GEN logn, half, n, r, i, tmp, t, o, l;
	int ok;
	long ltop;
	struct timeval stime, ftime, sptime, fptime, sp5time, fp5time;
	
	pari_init(20000000, 10000);

	n = flisexpr(argv[1]);

	// max degree = 65532

	printf("Overenie prvociselnosti pre  n = ");
	output(n);

/*		KROK 1		*/
	gettimeofday(&stime, NULL);

	GEN z;
	half = flisexpr("0.5");
	logn = gdiv(glog(n,5), glog(gdeux,5));
	ltop = avma;
	ok = 0;	i = gdeux;
	while(!(gcmp(i,logn) == 1) && (ok != 1)) {
		tmp = gpow(gfloor(gadd(half, gpow(gdeux, gdiv(logn, i), 5))), i, 5);
		if (gcmp(n, tmp) == 0) { ok = 1; }
		avma = ltop;
		i = gadd(i, gun);
	}
	avma = ltop;

	if (ok == 1) {
		printf("je to mocnina\n");
	}

	gettimeofday(&ftime, NULL);
	printf("Krok 1: %lld ms\n", (unsigned long long)1000*(ftime.tv_sec-stime.tv_sec)+(ftime.tv_usec-stime.tv_usec)/1000);
	printf("\n");

/*		KROK 2		*/
	gettimeofday(&stime, NULL);

	l = gtrunc(gsqr(gmul(gdeux, logn)));
	r = gdeux; ltop = avma;
	ok = 1;
	while(1) {
		if (gcmp(ggcd(n, r), gun) == 1) {
			if (gcmp(ggcd(n, r), n) == 0) {
				printf("je to prvocislo\n");
			} else {
				printf("je sudelitelne s ");
				output(r);
			}
			exit(0);
		}
		tmp = Mod0(n, r, 0);
		o = order(tmp);
		if (gcmp(o, l) == 1) break;
	//	avma = ltop;
		r = gadd(r, gun);
	}
	printf("Hladane r=%d  \n", itos(r));
	avma = ltop;
	
	gettimeofday(&ftime, NULL);
	printf("Krok 2: %lld ms\n", (unsigned long long)1000*(ftime.tv_sec-stime.tv_sec)+(ftime.tv_usec-stime.tv_usec)/1000);
	printf("\n");

/*		KROK 3		*/
// vynechany, pretoze sa pocita v kroku 2
/*
	gettimeofday(&stime, NULL);

	i = gun; tmp = gun; 
    ltop = avma;
	while(!(gcmp(i,r) == -1)) {
		tmp = ggcd(i, n);
		if ((gcmp(tmp, gun) == 1) && (gcmp(tmp, n) == 1)) {
			output(n);
			printf(" je zlozene cislo");
			exit(0);
		}
		avma = ltop;
		i = gadd(i, gun);
	}

	gettimeofday(&ftime, NULL);
	printf("Krok 3: %lld ms\n", (unsigned long long)1000*(ftime.tv_sec-stime.tv_sec)+(ftime.tv_usec-stime.tv_usec)/1000);
	printf("\n");
*/	
/*		KROK 4		*/
	gettimeofday(&stime, NULL);

	if (!(gcmp(n,r) == 1)) {
		output(n);
		printf(" je to prvocislo");
		exit(0);
	}

	gettimeofday(&ftime, NULL);
	printf("Krok 4: %lld ms\n", (unsigned long long)1000*(ftime.tv_sec-stime.tv_sec)+(ftime.tv_usec-stime.tv_usec)/1000);
	printf("\n");

/*		KROK 5		*/
	gettimeofday(&stime, NULL);
	GEN p1, p2, p3, p10, p11, x, tmp_pol1, tmp_pol2, tmp_pol3;
	unsigned long long k1 = 0, k2 = 0, k3 = 0, k4 = 0, k5 = 0, k6 = 0;
	i = gun;
	tmp = gtrunc(gmul(gdeux, gmul(gsqrt(phi(r),5), logn))); 
	x = flisexpr("x");
    tmp_pol3 = gpow(x, r, 5);				// konstanta: x^r
	tmp_pol2 = gsub(tmp_pol3, gun);			// konstanta: x^r-1
	p10 = gpow(Mod0(x, tmp_pol2, 0), n, 5);	// konstanta lava strana: X^n mod X^r-1

	ltop=avma;
	ok = 1;
	
	printf("Pocet opakovani cyklu: %d\n", itos(tmp));
	while(!(gcmp(i, tmp) == 1) && ok == 1) {
//		printf("prechod: ");
//		output(i);
		gettimeofday(&sp5time, NULL);

		/*	predpocitanie konstant	*/
		gettimeofday(&sptime, NULL);
			/*	konstanta 1:	i mod n		- prevod i na modulovany objekt	*/
			tmp_pol1 = Mod0(i, n, 0);
		gettimeofday(&fptime, NULL);
		k1 = k1 + (unsigned long long)1000*(fptime.tv_sec-sptime.tv_sec)+(fptime.tv_usec-sptime.tv_usec)/1000;

		/*	subkrok 1:			x + i		- pripocitanie modulovaneho i k polynomu	*/
		gettimeofday(&sptime, NULL);
			p1 = gadd(x, tmp_pol1);
		gettimeofday(&fptime, NULL);
		k2 = k2 + (unsigned long long)1000*(fptime.tv_sec-sptime.tv_sec)+(fptime.tv_usec-sptime.tv_usec)/1000;

		/* subkrok 2:			(x + i)	mod (x^r - 1)	- modulovanie polynomom	*/
		gettimeofday(&sptime, NULL);
			p2 = Mod0(p1, tmp_pol2, 0);
		gettimeofday(&fptime, NULL);
		k3 = k3 + (unsigned long long)1000*(fptime.tv_sec-sptime.tv_sec)+(fptime.tv_usec-sptime.tv_usec)/1000;

		/* subkrok 3:			(x + i)^n	- umocnenie modulovaneho polynomu na n	*/
		gettimeofday(&sptime, NULL);
			p3 = gpow(p2, n, 5);
		gettimeofday(&fptime, NULL);
		k4 = k4 + (unsigned long long)1000*(fptime.tv_sec-sptime.tv_sec)+(fptime.tv_usec-sptime.tv_usec)/1000;

		/* subkrok 4:			- vypocitanie lavej strany	*/
		gettimeofday(&sptime, NULL);
			p11 = gadd(p10, i);
		gettimeofday(&fptime, NULL);
		k5 = k5 + (unsigned long long)1000*(fptime.tv_sec-sptime.tv_sec)+(fptime.tv_usec-sptime.tv_usec)/1000;

		/* porovnanie pravej a lavej strany	*/
		if (gegal(p3, p11) != 1) {
			printf(" nie je to prvocislo \n");
			printf("koniec v opakovani %d\n", itos(i));
			ok = 0;
		}
		avma = ltop;
		i = gadd(i, gun);

		gettimeofday(&fp5time, NULL);
		k6 = k6 + (unsigned long long)1000*(fp5time.tv_sec-sp5time.tv_sec)+(fp5time.tv_usec-sp5time.tv_usec)/1000;
	}

	printf("Priemerny cas jedneho cyklu:  t = %lld ms\n", k6 / itos(i));
	printf("Jednotlive subkroky vypoctu:\n");
	printf("	predpocitanie konstanty:  t = %lld ms\n", k1 / itos(i));
	printf("	x + a                  :  t = %lld ms\n", k2 / itos(i));
	printf("	modulovanie PS (x^r-1) :  t = %lld ms\n", k3 / itos(i));
	printf("	umocnenie PS ^n        :  t = %lld ms\n", k4 / itos(i));
	printf("	vypocet LS             :  t = %lld ms\n", k5 / itos(i));

	gettimeofday(&ftime, NULL);
	printf("Krok 5: %lld ms\n", (unsigned long long)1000*(ftime.tv_sec-stime.tv_sec)+(ftime.tv_usec-stime.tv_usec)/1000);
	printf("\n");

// krok zaver
	if (ok == 1) {
		output(n);
		printf(" je to prvocislo");
	}
	
	return 0;
}
