#include "pari.h"
#include <sys/time.h>

void printoutbinary(int *binary, int count);

int main(int argc, char **argv)
{
	if (argc == 1) {
		printf("Zadaj hodnotu n\n");
		exit(0);
	}

	GEN N, logN, R;
	GEN res, pol;
	GEN copyN, bound, tmp, orderR;
	int *bin;						// binarny zapis cisla n
	int binSize;					// dlzka binarneho zapisu
	int ltop;						// vrch PARI zasobnika
	int cnt1, cnt2;					// iteratory na vseobecne pouzitie
	struct timeval stime, ftime, sptime, fptime, sp5time, fp5time; // casomiery
	int ok;
		
	pari_init(160000000, 10000);

	N = flisexpr(argv[1]);
	logN = gdiv(glog(N,5), glog(gdeux,5));
	binSize = itos(gfloor(gadd(logN, gun)));
	bin = (int*)malloc(binSize * sizeof(int));

	// vytvorenie binarneho zapisu
	cnt1 = 0; copyN = N;
	while (!gcmp0(copyN)) {
		bin[cnt1] = itos(lift(Mod0(copyN, gdeux, 0)));
		cnt1++;
		copyN = gdivexact(copyN, gdeux);
	}

/*		KROK 1		*/
	gettimeofday(&stime, NULL);

	GEN z;
	GEN half = flisexpr("0.5");
	GEN logn = gdiv(glog(N,5), glog(gdeux,5));
	ltop = avma;
	ok = 0;	GEN ii = gdeux;
	while(!(gcmp(ii,logn) == 1) && (ok != 1)) {
		tmp = gpow(gfloor(gadd(half, gpow(gdeux, gdiv(logn, ii), 5))), ii, 5);
		if (gcmp(N, tmp) == 0) { ok = 1; }
		avma = ltop;
		ii = gadd(ii, gun);
	}
	avma = ltop;

	if (ok == 1) {
		printf("je to mocnina\n");
	}

	gettimeofday(&ftime, NULL);
	printf("Krok 1: %lld ms\n", (unsigned long long)1000*(ftime.tv_sec-stime.tv_sec)+(ftime.tv_usec-stime.tv_usec)/1000);
	printf("\n"); 

/*		KROK 2		*/
	gettimeofday(&stime, NULL);
		
	bound = gtrunc(gsqr(gmul(gdeux, logN)));
	R = gdeux; ltop = avma;
	while(1) {
		if (gcmp(ggcd(N, R), gun) == 1) {
			if (gcmp(ggcd(N, R), N) == 0) {
				printf("je to prvocislo\n");
			} else {
				printf("je sudelitelne s ");
				output(R);
			}
			exit(0);
		}
		tmp = Mod0(N, R, 0);
		orderR = order(tmp);
		if (gcmp(orderR, bound) == 1) break;
		avma = ltop;
		R = gadd(R, gun);
	}
	printf("Hladane R = %d \n", itos(R));

	gettimeofday(&ftime, NULL);
	printf("Krok 2: %lld ms\n", (unsigned long long)1000*(ftime.tv_sec-stime.tv_sec)+(ftime.tv_usec-stime.tv_usec)/1000);
	printf("\n"); 
	
/*		KROK 3		*/
// vynechany, pretoze sa pocita v druhom kroku

/*		KROK 4		*/
	if (!(gcmp(N,R) == 1)) {
		output(N);
		printf(" je to prvocislo");
		exit(0);
	}
 
/*		KROK 5		*/
	gettimeofday(&stime, NULL);
		
	int intR = itos(R);
	int polySize = (intR * 2) + 1;

	printoutbinary(bin, binSize);

	ltop = avma;
	bound = gtrunc(gmul(gdeux, gmul(gsqrt(gsub(R, gun),5), logN)));
	int l = itos(bound);
	ok = 1; // 1= vsjo v poriadku
	GEN a = gun, tmpA;
	int i = 1, j, k;
	int degPol, degRes;
	unsigned long long k1 = 0;
	GEN tmp2, c, c2;
	entree e;
	
	GEN tmp_pol3 = gpow(flisexpr("x"), R, 5);		// konstanta: x^r
	GEN tmp_pol2 = gsub(tmp_pol3, gun);	
	GEN p10 = gpow(Mod0(flisexpr("x"), tmp_pol2, 0), N, 5);

	printf("Pocet opakovani cyklu: %d\n", l);
	
	while((ok == 1) && (i <= l)) {
		ltop = avma;
		pol = gadd(flisexpr("x"), Mod0(a, N, 0));
		res = gun;
		degPol = 1; degRes = 0;

		gettimeofday(&sptime, NULL);
		for(cnt1 = 0; cnt1 < binSize; cnt1++) {
			if (bin[cnt1] == 1) {
				res = gmul(pol, res);
				degRes = degRes + degPol;
				
				if (degRes >= intR) {
					tmp2 = vecteur(stoi(intR), &e, "");	// stupen + 1 (pre abs clen)
					cnt2 = 1;
				
					// prekopirovanie ostavajucich clenov
					for(k = intR - 1; k > degRes - intR; k--) {
						tmp2[cnt2] = (GEN)res[k + 2];
						cnt2++;
					}
				
					for(k = degRes; k >= intR; k--) {
						c = (GEN)res[k + 2];			// ktory sa rusi
						c2 = (GEN)res[k - intR + 2];	// kam sa presunie
						tmp2[cnt2] = gadd(c, c2);
						cnt2++;
					}
					res = gtopoly(tmp2, 0);
					degRes = poldegree(res, -1);
				}
			}

			pol = gsqr(pol);
			degPol = degPol * 2;
			if (degPol >= intR) {
				tmp2 = vecteur(stoi(intR), &e, "");
				cnt2 = 1;
				for(k = intR - 1; k > degPol - intR; k--) {
					tmp2[cnt2] = (GEN)pol[k + 2];
					cnt2++;
				}
				for(k = degPol; k >= intR; k--) {
					c = (GEN)pol[k + 2];			// ktory sa rusi
					c2 = (GEN)pol[k - intR + 2];	// kam sa presunie
					tmp2[cnt2] = gadd(c, c2);
					cnt2++;
				}
				pol = gtopoly(tmp2, 0);
				degPol = poldegree(pol, -1);
			}
		}

		gettimeofday(&fptime, NULL);
		k1 = k1 + (unsigned long long)1000*(fptime.tv_sec-sptime.tv_sec)+(fptime.tv_usec-sptime.tv_usec)/1000;

		// porovnanie LS a PS
		GEN p11 = gadd(p10, a);	// prva strana
		if (gegal(res, p11) != 1) {
			printf(" nie je to prvocislo");
			output(N);
			exit(0);
		} 
		avma = ltop;

		// vytvorenie dalsieho, rozne kvoli praci so zasobnikom		
		if (i==2) {
			a = gadd(a, gun);
			ltop = avma;			
		}
		if (i>2) {
			gaddz(a, gun, a);
		}
		if (i==1) {
			a = gdeux;
		}
		
		i++;
	} // hlavny while

	printf("Priemerny cas jedneho cyklu:  t = %lld ms\n", k1 / (--i)); 

	gettimeofday(&ftime, NULL);
	printf("Krok 5: %lld ms\n", (unsigned long long)1000*(ftime.tv_sec-stime.tv_sec)+(ftime.tv_usec-stime.tv_usec)/1000);
	printf("\n"); 

	if (ok==1) {
		printf("Je to prvocislo\n");
	} else {
		printf("Je to zlozene cislo, zistene v prechode: ");
		output(gsub(a, gun));
	}
	
	return 0;
}

// na vypisanie binarneho rozvoja, najvyznamnejsi bit prvy
void printoutbinary(int *binary, int count)
{
	int i;
	printf("binary size = %d; [", count);
	for(i = count - 1; i >= 0; i--) {
		printf("%d", binary[i]);
	}
	printf("]\n");
}
