/// unit obsahuje proceduru na naplnenie hasovacej tabulky lokalizovanymi stringami
unit langstrings;

interface

uses constants,hashmap;

procedure fillWithStrings(var hashmap: TStrIntHashMap);

implementation

/// procedura naplni vstupny hashhmap lokalizovanymi stringami
procedure fillWithStrings(var hashmap: TStrIntHashMap);
begin
  if hashmap = nil then
    Exit;
  with hashmap do begin
    add(STR_LANGID, 'English');
    add(STR_YES,' Yes');
    add(STR_NO,' No');
    add(STR_CANCEL, 'Cancel');
    add(STR_MAYBE, 'Maybe');
    add(STR_ERROR, 'Error');
    add(STR_ERROR_IN_1, 'Error in (%1%)');
    add(STR_WARNING, 'Warning');
    add(STR_WARNING_IN_1, 'Warning in (%1%)');
    add(STR_SUCCESS, 'Success');
    add(STR_SUCCESS_IN_1, 'Success in (%1%)');
    add(STR_NAME, 'Name');
    add(STR_SIZE, 'Size');
    add(STR_MODIFIED, 'Modified');
    add(STR_DIFF_COUNT, 'Diff Count');
    add(STR_REL_FOLDER, 'Relative Folder');
    add(STR_ID, 'Identifier');
    add(STR_REGEXP, 'Regular Expresion');
    add(STR_RIGHT_SIDE, 'Right Side Of Production');
    add(STR_POSITION, 'Position');
    add(STR_LEFT_SIDE, 'Left Side Of Production');
    add(STR_LR0ITEM, 'LR0 Item');
    add(STR_LOOKAHEAD, 'Lookahead');
    add(STR_RULENUMBER, 'Rule Number');
    add(STR_ACTIONTYPE, 'Action type');
    add(STR_TOKEN, 'Token');
    add(STR_ACTION, 'Action');
    add(STR_SHIFT, 'SHIFT');
    add(STR_REDUCE, 'REDUCE');
    add(STR_SYMBOL, 'Symbol');
    add(STR_STATE, 'State');
    add(STR_ACCEPT, 'ACCEPT');

    add(E_GF_UNEXPECTED_CHAR_FOUND_1, 'Unexpected character found - ''%1%''');
    add(E_GF_EXPECTED_1_INSTEAD_OF_EOL, 'Expected ''%1%'' instead of EOL');
    add(E_GF_EXPECTED_1, 'Expected ''%1%''');
    add(E_GF_EXPECTED_1_INSTEAD_OF_EOF, 'Expected ''%1%'' instead of EOF');
    add(E_GF_PROPERTY_EXPECTED_EQ_INSTEAD_OF_1, 'Property declaration: expected = instead of ''%1%''');
    add(E_GF_PROPERTY_EXPECTED_STRING_OR_STATE_INSTEAD_OF_1, 'Property declaration: expected value ...,<...>,''...'' instead of ''%1%''');
    add(E_GF_SET_EXPECTED_EQ_INSTEAD_OF_1, 'Set declaration: expected = instead of ''%1%''');
    add(E_GF_SET_EXPECTED_STRING_OR_STATE_OR_SETSTRING_INSTEAD_OF_1, 'Set declaration: expected value ...,[...],{...},''...'' instead of ''%1%''');
    add(E_GF_REGEXP_INVALID_OPERATOR_1_FOUND_REGEXPOP_EXPECTED, 'Invalid operator found: ''%1%'', expected +*?|[instead of EOF');
    add(E_GF_REGEXP_TOO_MANY_CLOSING_BRACKETS_1_CORRESPONDING_OB_MISSING, 'RegExp declaration: Too many closing brackets ''%1%'', corresponding opening bracket not found');
    add(E_GF_TERMINAL_EXPECTED_EQ_INSTEAD_OF_1, 'Terminal parsing: Expected = instead of ''%1%''');
    add(E_GF_STATE_EXPECTED_ASSIGN_INSTEAD_OF_1, 'Rule parsing: Expected = instead of ''%1%''');
    add(E_GF_RULE_EXPECTED_STATE_OR_STRING_OR_OP_INSTEAD_OF_1, 'Rule parsing: Expected Terminal/Non-terminal/String/Operator instead of ''%1%''');
    add(E_GF_RULE_INVALID_OPERATOR_1_IN_RULE_2_DEFINITION_ONLY_OR_ALLOWED, 'Rule parsing: Invalid operator ''%1%'' in rule ''%2%'' definition, only | allowed');
    add(E_GF_RULE_TERMINAL_WITH_NAME_1_NOT_DEFINED, 'Rule parsing: Terminal with name ''%1%'' not defined');
    add(E_GF_RULE_EMPTY_OR_NOT_VALID_RIGHT_SIDE_1, 'Rule parsing: Empty or not valid right side ''%1%''');
    add(E_GF_START_SYMBOL_NOT_DECLARED_AND_NO_VALID_RULES_DECLARED, 'Start symbol missing and no rules found');
    add(E_GF_NONTERMINAL_1_IN_NO_RULE_AS_HEADER, 'Non-terminal ''%1%'' in no rule as header');
    add(E_GF_LOAD_ERROR_IN_FILE_1, 'Load error in grammar file ''%1%''');
    add(E_GF_ERROR_IN_TERMINAL_PARSING_1, 'Error in terminal parsing ''%1%''');
    add(E_GF_ERROR_IN_STATE_PARSING_1, 'Error in non-terminal parsing ''%1%''');
    add(E_GF_INTEGER_NUMBER_EXPECTED_INSTEAD_OF_1, 'Integer number expected instead of ''%1%''');
    add(E_GF_TERMINAL_OR_NONTERMINAL_1_NOT_DEFINED, 'Terminal/Non-terminal: ''%1%'' not defined');
    add(E_GF_TERMINAL_OR_NONTERMINAL_1_ALREADY_IN_OTHER_EQUIVALENCE_SET, 'Terminal/Non-terminal: ''%1%'' already in another equivalence set');
    add(E_GF_TERMINAL_OR_NONTERMINAL_1_ALREADY_IN_OTHER_SIMILARITY_SET, 'Terminal/Non-terminal: ''%1%'' already in another similarity set');
    add(E_GF_TERMINAL_STATE_OR_STRING_EXPECTED_INSTEAD_OF_1, 'Terminal/State(non-terminal)/String(terminal) expected, instead of ''%1%''');
    add(E_PARSING_INVALID_TOKEN, 'Parsing: [State %1%] invalid input symbol - %2% (%3%)');
    add(E_PARSING_PARSE_ERRORS_THRESHOLD_EXCEEDED, 'Parsing: [State %1%] parse error threshold exceeded, removing virtual tokens - %2% (%3%)');
    add(E_PARSING_NO_POSSIBLE_ACTION, 'Parsing: [State %1%] no possible reduce actions on lookahead %2% (%3%)');

    add(W_RES_STRING_MISSING, '!!!Resource string missing!!! [%L%:%I%] PROBLEM #%I%: (%1%) (%2%)');
    add(W_GF_TERMINAL_REDEFINED_1, 'Terminal ''%1%'' already defined (adding as OR branch into automaton)');
    add(W_GF_SET_REDEFINED_1, 'Set ''%1%'' already defined (replacing old definition)');
    add(W_GF_REGEXP_SET_1_NOT_DEFINED_CREATING_DUMMY_2, 'RegExp declaration: Set ''%1%'' not defined, creating dummy %2%');
    add(W_GF_REGEXP_EMPTY_STRING_IN_TOKEN_1_DEFINITION, 'RegExp declaration: Empty string in token ''%1%'' definition');
    add(W_GF_SET_SET_1_NOT_DEFINED, 'Set declaration: Set ''%1%'' not defined');
    add(W_GF_RULE_EMPTY_STRING_1_IN_RULE_2_DEFINITION_EPSILON, 'Rule parsing: Empty string ''%1%'' in rule ''%2%'' - definition of epsilon hour');
    add(W_GF_RULE_TERMINAL_WITH_NAME_1_ALREADY_EXISTS_POSSIBLE_MISTAKE, 'Terminal with the same name - ''%1%'' already exists, possible mistake');
    add(W_GF_START_SYMBOL_NOT_DECLARED_USING_FIRST_FOUND_1, 'Start symbol not declared using first found: ''%1%'' !');
    add(W_GF_START_SYMBOL_1_RULE_IS_MISSING, 'Start symbol ''%1%'' rule missing');
    add(W_GF_START_SYMBOL_MISSING_USING_FIRST_FOUND_1, 'Start symbol missing, using first found : ''%1%'' !');
    add(W_GF_SUPPOSED_WS_TERMINAL_1_IS_NOT_EVEN_DEFINED, 'Supposed WS Terminal ''%1%'' is not even defined');
    add(W_GF_RULE_EXACT_SAME_RULE_FOR_HEAD_1_ALREADY_DEFINED_AT_POS_2, 'Identical rule for head ''%1%'' already defined, at position %2%');
    add(W_GF_TERMINAL_1_DECLARED_BUT_NOT_USED, 'Terminal ''%1%'' declared, but never used');
    add(W_GF_RULE_EXPECTED_RULE_HEADER_OR_SEPARATOR_AS_FIRST_SYMBOL_ON_NEW_LINE_INSTEAD_OF_1, 'Expected rule header or separator as first symbol on new line, instead of ''%1%''');
    add(W_GF_SUPPOSED_COMMENT_TERMINAL_1_FROM_PROPERTY_2_IS_NOT_EVEN_DEFINED, 'Supposed COMMENT... Terminal ''%1%'' from property ''%2%'' is not even defined');
    add(W_GF_SUPPOSED_EOLNWS_TERMINAL_1_IS_NOT_EVEN_DEFINED, 'Supposed EOLNWS Terminal ''%1%'' is not even defined');
    add(W_PB_SHIFT_REDUCE_SHIFT, 'Parser Builder: [State %1%] SHIFT/REDUCE conflict detected: SHIFT on symbol - %2% to [State %3%]');
    add(W_PB_SHIFT_REDUCE_REDUCE, 'Parser Builder: [State %1%] SHIFT/REDUCE conflict detected: REDUCE on lookahead - %2% by rule %3%');
    add(W_PB_REDUCE_REDUCE_ORIG, 'Parser Builder: [State %1%] REDUCE/REDUCE conflict detected: REDUCE on lookahead - %2% by rule %3%');
    add(W_PB_REDUCE_REDUCE_REDUCE, 'Parser Builder: [State %1%] REDUCE/REDUCE conflict detected: REDUCE on lookahead - %2% by rule %3%');
    add(W_PARSING_SHIFT_REDUCE_SHIFT, 'Parsing: [State %1%] SHIFT/REDUCE conflict: shift on symbol - %2% (%3%)');
    add(W_PARSING_SHIFT_REDUCE_REDUCE, 'Parsing: [State %1%] SHIFT/REDUCE conflict: reduce on lookahead - %2% (%3%)');
    add(W_PARSING_REDUCE_REDUCE_REDUCE, 'Parsing: [State %1%] REDUCE/REDUCE conflict: reduce on lookahead - %2% (%3%)');
  end;
end;

end.

