/// unit zobrazujuci okno s nastaveniami
unit options;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons;

type
  //trieda zobrazujuca okno s nastaveniami
  TOptionsForm = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    PageControl1: TPageControl;
    Parser: TTabSheet;
    General: TTabSheet;
    Diff: TTabSheet;
    PrettyPrinter: TTabSheet;
    Colors: TTabSheet;
    Paths: TTabSheet;
    GroupBox1: TGroupBox;
    AFListBoxLogsEnabled: TCheckBox;
    AFListBoxShowErrors: TCheckBox;
    AFListBoxShowWarnings: TCheckBox;
    AFListBoxShowMiscs: TCheckBox;
    GroupBox2: TGroupBox;
    AFXSynchronizedScrollBars: TCheckBox;
    AFYSynchronizedScrollBars: TCheckBox;
    AFXRecursiveFolders: TCheckBox;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    ACYCLE_THRESHOLD: TEdit;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    AFAlwaysConvertToDFA: TCheckBox;
    GroupBox6: TGroupBox;
    ADEFAULT_CASE_SENSITIVITY: TCheckBox;
    ADEFAULT_PARSE_COMMENTS: TCheckBox;
    Label2: TLabel;
    AMAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS: TEdit;
    Label3: TLabel;
    AMAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE: TEdit;
    Label4: TLabel;
    ALEX_ERRORS_THRESHOLD: TEdit;
    Label5: TLabel;
    APARSE_ERRORS_THRESHOLD: TEdit;
    Label6: TLabel;
    AApplicationHelpFile: TEdit;
    OpenDialog1: TOpenDialog;
    ColorDialog1: TColorDialog;
    GroupBox7: TGroupBox;
    GroupBox8: TGroupBox;
    ACOLOR_TEXTBACKGROUND: TStaticText;
    ACOLOR_GUTTER: TStaticText;
    ACOLOR_NEWGUTTER: TStaticText;
    ACOLOR_INSERT: TStaticText;
    ACOLOR_DELETE: TStaticText;
    ACOLOR_CHANGE: TStaticText;
    ACOLOR_MATCH: TStaticText;
    ACOLOR_NOT_COMPARED: TStaticText;
    ACOLOR_COMBINED: TStaticText;
    ATCOLOR_DEFAULT: TStaticText;
    ATCOLOR_GUTTER: TStaticText;
    ATCOLOR_NEWGUTTER: TStaticText;
    ATCOLOR_INSERT: TStaticText;
    ATCOLOR_DELETE: TStaticText;
    ATCOLOR_CHANGE: TStaticText;
    ATCOLOR_MATCH: TStaticText;
    ATCOLOR_NOT_COMPARED: TStaticText;
    ATCOLOR_COMBINED: TStaticText;
    Label7: TStaticText;
    Label8: TStaticText;
    Label9: TStaticText;
    Label10: TStaticText;
    Label11: TStaticText;
    Label12: TStaticText;
    Label13: TStaticText;
    Label14: TStaticText;
    Label15: TStaticText;
    Label16: TStaticText;
    Label17: TStaticText;
    Label18: TStaticText;
    Label19: TStaticText;
    Label20: TStaticText;
    Label21: TStaticText;
    Label22: TStaticText;
    Label23: TStaticText;
    Label24: TStaticText;
    Button3: TButton;
    GroupBox9: TGroupBox;
    GroupBox10: TGroupBox;
    GroupBox11: TGroupBox;
    AFEnabledFormatting: TCheckBox;
    AFFormattingWithBkColor: TCheckBox;
    AFDisableWSDiffsColoring: TCheckBox;
    ANEW_LINE_PREV_LINE_TOKEN_ASPACES: TCheckBox;
    AMULTI_LINE_COMMENTS_IND: TCheckBox;
    ATREE_FORMATTING: TCheckBox;
    ATAB_SPACES: TEdit;
    ADEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE: TEdit;
    Label25: TLabel;
    Label26: TLabel;
    ATSTYLE_DEFAULT_INT: TEdit;
    Label27: TLabel;
    Label28: TLabel;
    ACOLOR_PB_SCROLLBAR_OUTLINE: TStaticText;
    GroupBox12: TGroupBox;
    GroupBox13: TGroupBox;
    AFSelectedLineLCS: TCheckBox;
    ADIFF_CASE_SENSITIVE: TCheckBox;
    ADIFF_WS_FILTERING: TCheckBox;
    ADIFF_WS: TEdit;
    Label29: TLabel;
    Label30: TLabel;
    ADEFAULT_EQ_SCORE: TEdit;
    Label31: TLabel;
    ADEFAULT_SIM_SCORE: TEdit;
    Label32: TLabel;
    ASANE_ARRAY_SIZE_LIMIT: TEdit;
    procedure AApplicationHelpFileMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure ACOLOR_PB_SCROLLBAR_OUTLINEClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ATCOLOR_COMBINEDClick(Sender: TObject);
    procedure ATCOLOR_NOT_COMPAREDClick(Sender: TObject);
    procedure ATCOLOR_MATCHClick(Sender: TObject);
    procedure ATCOLOR_CHANGEClick(Sender: TObject);
    procedure ATCOLOR_DELETEClick(Sender: TObject);
    procedure ATCOLOR_INSERTClick(Sender: TObject);
    procedure ATCOLOR_NEWGUTTERClick(Sender: TObject);
    procedure ATCOLOR_GUTTERClick(Sender: TObject);
    procedure ATCOLOR_DEFAULTClick(Sender: TObject);
    procedure ACOLOR_COMBINEDClick(Sender: TObject);
    procedure ACOLOR_NOT_COMPAREDClick(Sender: TObject);
    procedure ACOLOR_MATCHClick(Sender: TObject);
    procedure ACOLOR_CHANGEClick(Sender: TObject);
    procedure ACOLOR_DELETEClick(Sender: TObject);
    procedure ACOLOR_INSERTClick(Sender: TObject);
    procedure ACOLOR_NEWGUTTERClick(Sender: TObject);
    procedure ACOLOR_GUTTERClick(Sender: TObject);
    procedure ACOLOR_TEXTBACKGROUNDClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    procedure pickColor(lab: TObject);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OptionsForm: TOptionsForm;

implementation

{$R *.dfm}

uses constants, folderdiff, mainframe, filediff;

/// procedura na obsluhujuca stlacenie tlacidla OK,
/// po stlaceni tohto tlacidla aplikuje vsetky nastavenia do globalnych premennych a zatvori okno
procedure TOptionsForm.Button1Click(Sender: TObject);
var i: Integer;
begin
  //save to global constants
  //general tab
  FListBoxLogsEnabled := AFListBoxLogsEnabled.Checked;
  FListBoxShowErrors := AFListBoxShowErrors.Checked;
  FListBoxShowWarnings := AFListBoxShowWarnings.Checked;
  FListBoxShowMiscs := AFListBoxShowMiscs.Checked;

  FXSynchronizedScrollBars := AFXSynchronizedScrollBars.Checked;
  FYSynchronizedScrollBars := AFYSynchronizedScrollBars.Checked;
  FXRecursiveFolders := AFXRecursiveFolders.Checked;

  i := StrToIntDef(ACYCLE_THRESHOLD.Text,CYCLE_THRESHOLD);
//  if i > 0 then
    CYCLE_THRESHOLD := i;

  //parser tab
  FAlwaysConvertToDFA := AFAlwaysConvertToDFA.Checked;
  DEFAULT_CASE_SENSITIVITY := ADEFAULT_CASE_SENSITIVITY.Checked;
  DEFAULT_PARSE_COMMENTS := ADEFAULT_PARSE_COMMENTS.Checked;

  MAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS := StrToIntDef(AMAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS.Text,MAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS);
  MAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE := StrToIntDef(AMAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE.Text,MAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE);
  PARSE_ERRORS_THRESHOLD := StrToIntDef(APARSE_ERRORS_THRESHOLD.Text,PARSE_ERRORS_THRESHOLD);
  LEX_ERRORS_THRESHOLD := StrToIntDef(ALEX_ERRORS_THRESHOLD.Text,LEX_ERRORS_THRESHOLD);

  //diff tab
  FSelectedLineLCS := AFSelectedLineLCS.Checked;

  DIFF_CASE_SENSITIVE := ADIFF_CASE_SENSITIVE.Checked;
  DIFF_WS_FILTERING := ADIFF_WS_FILTERING.Checked;

  DIFF_WS := resolveSimpleSeq(ADIFF_WS.Text);

  DEFAULT_EQ_SCORE := StrToIntDef(ADEFAULT_EQ_SCORE.Text,DEFAULT_EQ_SCORE);
  DEFAULT_SIM_SCORE := StrToIntDef(ADEFAULT_SIM_SCORE.Text,DEFAULT_SIM_SCORE);

  i := StrToIntDef(ASANE_ARRAY_SIZE_LIMIT.Text,SANE_ARRAY_SIZE_LIMIT);
//  if i > 0 then
    SANE_ARRAY_SIZE_LIMIT := i;

  //pretty printer tab
  FEnabledFormatting := AFEnabledFormatting.Checked;
  FFormattingWithBkColor := AFFormattingWithBkColor.Checked;
  FDisableWSDiffsColoring := AFDisableWSDiffsColoring.Checked;

  NEW_LINE_PREV_LINE_TOKEN_ASPACES := ANEW_LINE_PREV_LINE_TOKEN_ASPACES.Checked;
  MULTI_LINE_COMMENTS_IND := AMULTI_LINE_COMMENTS_IND.Checked;
  TREE_FORMATTING := ATREE_FORMATTING.Checked;

  i := StrToIntDef(ATAB_SPACES.Text,TAB_SPACES);
  if (i >= 0) and (i < $100) then
    TAB_SPACES := i;

  i := StrToIntDef(ADEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE.Text,DEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE);
  if (i >= 0) and (i < $1000) then
    DEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE := i;

  i := StrToIntDef(ATSTYLE_DEFAULT_INT.Text,TSTYLE_DEFAULT_INT);
  if (i >= 0) and (i < $10) then
    TSTYLE_DEFAULT_INT := i;

  COLOR_PB_SCROLLBAR_OUTLINE := ACOLOR_PB_SCROLLBAR_OUTLINE.Color;

  //colors tab
  COLOR_TEXTBACKGROUND := ACOLOR_TEXTBACKGROUND.Color;
  COLOR_GUTTER := ACOLOR_GUTTER.Color;
  COLOR_NEWGUTTER := ACOLOR_NEWGUTTER.Color;
  COLOR_INSERT := ACOLOR_INSERT.Color;
  COLOR_DELETE := ACOLOR_DELETE.Color;
  COLOR_CHANGE := ACOLOR_CHANGE.Color;
  COLOR_MATCH := ACOLOR_MATCH.Color;
  COLOR_NOT_COMPARED := ACOLOR_NOT_COMPARED.Color;

  COLOR_COMBINED := ACOLOR_COMBINED.Color;

  TCOLOR_DEFAULT := ATCOLOR_DEFAULT.Color;
  TCOLOR_GUTTER := ATCOLOR_GUTTER.Color;
  TCOLOR_NEWGUTTER := ATCOLOR_NEWGUTTER.Color;
  TCOLOR_INSERT := ATCOLOR_INSERT.Color;
  TCOLOR_DELETE := ATCOLOR_DELETE.Color;
  TCOLOR_CHANGE := ATCOLOR_CHANGE.Color;
  TCOLOR_MATCH := ATCOLOR_MATCH.Color;
  TCOLOR_NOT_COMPARED := ATCOLOR_NOT_COMPARED.Color;

  TCOLOR_COMBINED := ATCOLOR_COMBINED.Color;

  //paths tab
  Application.HelpFile := AApplicationHelpFile.Text;

  //control buttons sychronization
  FolderDiffForm.RecursiveFoldersTB.down := FXRecursiveFolders;
  MainForm.RecursiveSubfolders1.checked := FXRecursiveFolders;
  FolderDiffForm.SynchronizedScrollBarsTB.down := FXSynchronizedScrollBars;
  MainForm.SynchronizedScrollBars1.checked := FXSynchronizedScrollBars;
  FileDiffForm.SynchronizedScrollBarsTB.down := FYSynchronizedScrollBars;
  MainForm.SynchronizedScrollBars2.checked := FYSynchronizedScrollBars;
  FileDiffForm.FormattingTB.down := FEnabledFormatting;
  MainForm.Formatting1.checked := FEnabledFormatting;

  ModalResult := mrOK;
  Hide;
end;

/// procedura na obsluhujuca stlacenie tlacidla Cancel,
/// po stlaceni tohto tlacidla iba zatvori okno
procedure TOptionsForm.Button2Click(Sender: TObject);
begin
  ModalResult := mrCancel;
  Hide;
end;

/// procedura vykonavajuca sa tesne po zobrazeni tohto okna, nacita
/// hodnoty z globalnych premennych a zobrazi ich vo forme checkboxov a editboxov
procedure TOptionsForm.FormShow(Sender: TObject);
begin
  //load from global constants

  //general tab
  AFListBoxLogsEnabled.Checked := FListBoxLogsEnabled;
  AFListBoxShowErrors.Checked := FListBoxShowErrors;
  AFListBoxShowWarnings.Checked := FListBoxShowWarnings;
  AFListBoxShowMiscs.Checked := FListBoxShowMiscs;

  AFXSynchronizedScrollBars.Checked := FXSynchronizedScrollBars;
  AFYSynchronizedScrollBars.Checked := FYSynchronizedScrollBars;
  AFXRecursiveFolders.Checked := FXRecursiveFolders;

  ACYCLE_THRESHOLD.Text := IntToStr(CYCLE_THRESHOLD);

  //parser tab
  AFAlwaysConvertToDFA.Checked := FAlwaysConvertToDFA;
  ADEFAULT_CASE_SENSITIVITY.Checked := DEFAULT_CASE_SENSITIVITY;
  ADEFAULT_PARSE_COMMENTS.Checked := DEFAULT_PARSE_COMMENTS;

  AMAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS.Text := IntToStr(MAX_NUMBER_OF_TURNS_FROM_INSERTED_SYMBOLS);
  AMAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE.Text := IntToStr(MAX_SIZE_OF_INSERTED_SYMBOLS_QUEUE);
  APARSE_ERRORS_THRESHOLD.Text := IntToStr(PARSE_ERRORS_THRESHOLD);
  ALEX_ERRORS_THRESHOLD.Text := IntToStr(LEX_ERRORS_THRESHOLD);

  //diff tab
  AFSelectedLineLCS.Checked := FSelectedLineLCS;

  ADIFF_CASE_SENSITIVE.Checked := DIFF_CASE_SENSITIVE;
  ADIFF_WS_FILTERING.Checked := DIFF_WS_FILTERING;

  ADIFF_WS.Text := makeSimpleSeq(DIFF_WS);

  ADEFAULT_EQ_SCORE.Text := IntToStr(DEFAULT_EQ_SCORE);
  ADEFAULT_SIM_SCORE.Text := IntToStr(DEFAULT_SIM_SCORE);

  ASANE_ARRAY_SIZE_LIMIT.Text := IntToStr(SANE_ARRAY_SIZE_LIMIT);

  //prettyprinter tab
  AFEnabledFormatting.Checked := FEnabledFormatting;
  AFFormattingWithBkColor.Checked := FFormattingWithBkColor;
  AFDisableWSDiffsColoring.Checked := FDisableWSDiffsColoring;

  ANEW_LINE_PREV_LINE_TOKEN_ASPACES.Checked := NEW_LINE_PREV_LINE_TOKEN_ASPACES;
  AMULTI_LINE_COMMENTS_IND.Checked := MULTI_LINE_COMMENTS_IND;
  ATREE_FORMATTING.Checked := TREE_FORMATTING;

  ATAB_SPACES.Text := IntToStr(TAB_SPACES);
  ADEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE.Text := IntToStr(DEFAULT_LINECHAR_LIMIT_IN_NO_INPUT_MODE);

  ATSTYLE_DEFAULT_INT.Text := IntToStr(TSTYLE_DEFAULT_INT);
  ACOLOR_PB_SCROLLBAR_OUTLINE.Color := COLOR_PB_SCROLLBAR_OUTLINE;

  //colors tab
  ACOLOR_TEXTBACKGROUND.Color := COLOR_TEXTBACKGROUND;
  ACOLOR_GUTTER.Color := COLOR_GUTTER;
  ACOLOR_NEWGUTTER.Color := COLOR_NEWGUTTER;
  ACOLOR_INSERT.Color := COLOR_INSERT;
  ACOLOR_DELETE.Color := COLOR_DELETE;
  ACOLOR_CHANGE.Color := COLOR_CHANGE;
  ACOLOR_MATCH.Color := COLOR_MATCH;
  ACOLOR_NOT_COMPARED.Color := COLOR_NOT_COMPARED;

  ACOLOR_COMBINED.Color := COLOR_COMBINED;

  ATCOLOR_DEFAULT.Color := TCOLOR_DEFAULT;
  ATCOLOR_GUTTER.Color := TCOLOR_GUTTER;
  ATCOLOR_NEWGUTTER.Color := TCOLOR_NEWGUTTER;
  ATCOLOR_INSERT.Color := TCOLOR_INSERT;
  ATCOLOR_DELETE.Color := TCOLOR_DELETE;
  ATCOLOR_CHANGE.Color := TCOLOR_CHANGE;
  ATCOLOR_MATCH.Color := TCOLOR_MATCH;
  ATCOLOR_NOT_COMPARED.Color := TCOLOR_NOT_COMPARED;

  ATCOLOR_COMBINED.Color := TCOLOR_COMBINED;

  //paths tab
  AApplicationHelpFile.Text := Application.HelpFile;

end;

/// procedura na zobrazenie Color Dialogu na vybratie farby
procedure TOptionsForm.pickColor(lab: TObject);
begin
  with lab as TStaticText do begin
    ColorDialog1.Color := Color;
    if ColorDialog1.Execute then
      Color := ColorDialog1.Color;
  end;
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ACOLOR_TEXTBACKGROUNDClick(Sender: TObject);
begin
  pickColor(ACOLOR_TEXTBACKGROUND);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ACOLOR_GUTTERClick(Sender: TObject);
begin
  pickColor(ACOLOR_GUTTER);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ACOLOR_NEWGUTTERClick(Sender: TObject);
begin
  pickColor(ACOLOR_NEWGUTTER);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ACOLOR_INSERTClick(Sender: TObject);
begin
  pickColor(ACOLOR_INSERT);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ACOLOR_DELETEClick(Sender: TObject);
begin
  pickColor(ACOLOR_DELETE);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ACOLOR_CHANGEClick(Sender: TObject);
begin
  pickColor(ACOLOR_CHANGE);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ACOLOR_MATCHClick(Sender: TObject);
begin
  pickColor(ACOLOR_MATCH);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ACOLOR_NOT_COMPAREDClick(
  Sender: TObject);
begin
  pickColor(ACOLOR_NOT_COMPARED);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ACOLOR_COMBINEDClick(Sender: TObject);
begin
  pickColor(ACOLOR_COMBINED);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ATCOLOR_DEFAULTClick(Sender: TObject);
begin
  pickColor(ATCOLOR_DEFAULT);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ATCOLOR_GUTTERClick(Sender: TObject);
begin
  pickColor(ATCOLOR_GUTTER);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ATCOLOR_NEWGUTTERClick(Sender: TObject);
begin
  pickColor(ATCOLOR_NEWGUTTER);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ATCOLOR_INSERTClick(Sender: TObject);
begin
  pickColor(ATCOLOR_INSERT);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ATCOLOR_DELETEClick(Sender: TObject);
begin
  pickColor(ATCOLOR_DELETE);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ATCOLOR_CHANGEClick(Sender: TObject);
begin
  pickColor(ATCOLOR_CHANGE);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ATCOLOR_MATCHClick(Sender: TObject);
begin
  pickColor(ATCOLOR_MATCH);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ATCOLOR_NOT_COMPAREDClick(Sender: TObject);
begin
  pickColor(ATCOLOR_NOT_COMPARED);
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ATCOLOR_COMBINEDClick(Sender: TObject);
begin
  pickColor(ATCOLOR_COMBINED);
end;

/// procedura na obsluhu tlacidla ... pri vybere cesty k help suboru,
/// po stlaceni sa zobrazi Open Dialog, v ktorom sa vyberie nova cesta k help suboru
procedure TOptionsForm.Button3Click(Sender: TObject);
begin
  OpenDialog1.Title := 'Load Help File';
  OpenDialog1.DefaultExt := 'hlp';
  OpenDialog1.Filter := 'Help Files (*.hlp)|*.hlp';
  if OpenDialog1.Execute then begin
    AApplicationHelpFile.Text := OpenDialog1.FileName;
  end;
end;

/// procedura obsluhu kliknutia na tlacitko zobrazujuce momentalnu farbu danej polozky, zobrazi Color Dialog na vyber novej farby
procedure TOptionsForm.ACOLOR_PB_SCROLLBAR_OUTLINEClick(Sender: TObject);
begin
  pickColor(ACOLOR_PB_SCROLLBAR_OUTLINE);
end;

/// procedura zobrazujuca celu cesty v podobe float textu, pri zotrvani mysi nad tymto edit boxom
procedure TOptionsForm.AApplicationHelpFileMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  AApplicationHelpFile.Hint := AApplicationHelpFile.Text;
end;

end.
