/// unit obsahujuci jednoduche inline funkcie
unit simple;

interface

uses constants;

  function min(a,b: Integer): Integer; inline;
  function max(a,b: Integer): Integer; inline;
  function overflowwrap(a,t: Integer): Integer; inline;
  function zerowrap(a,t: Integer): Integer; inline;
  function log10(X: Integer): Integer; inline;
  function stripSlash(const path: xString): xString;
  function appendSlash(const path: xString): xString;

implementation

  /// funkcia vracajuca mensi zo vstupov
  function min(a,b: Integer): Integer; inline;
  begin
    if a < b then
      result := a
    else
      result := b;
  end;

  /// funkcia vracajuca vacsi zo vstupov
  function max(a,b: Integer): Integer; inline;
  begin
    if a < b then
      result := b
    else
      result := a;
  end;

  /// funkcia vracajuca hodnotu a, ktora patri do intervalu <0,t), ak je vacsia, tak sa berie hodnota a - t
  function overflowwrap(a,t: Integer): Integer; inline;
  begin
    if a < t then
      result := a
    else
      result := a - t;
  end;

  /// funkcia vracajuca hodnotu a, ktora patri do intervalu <0,t), ak je mensia ako 0, tak sa berie hodnota a + t
  function zerowrap(a,t: Integer): Integer; inline;
  begin
    if a < 0 then
      result := a + t
    else
      result := a;
  end;

  /// funkcia pocitajuca celociselny desiatkovy logaritmus zo vstupneho cisla x
  function log10(x: Integer): Integer; inline;
  begin
    result := 1;
    while x > 9 do begin
      result := result + 1;
      x := x div 10;
    end;
  end;

  /// funkcia odstranujuca koncovy \ znak zo stringu
  function stripSlash(const path: xString): xString;  //!LINUX!
  var len: integer;
  begin
    result := path;
    len := length(path);
    if (len = 0) or (path[len] <> '\') then
      Exit;
    setlength(result,len-1);
  end;

  /// funkcia pridavajuca koncovy \ znak do stringu
  function appendSlash(const path: xString): xString;  //!LINUX!
  var len: integer;
  begin
    len := length(path);
    if (len = 0) or (path[len] = '\') then
      result := path
    else
      result := path+'\';
  end;
end.
