unit test;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, main, ComCtrls, constants, structures, tree, filereader, langres, hashmap, tables, LCS;

type
  TTestForm = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    TreeView1: TTreeView;
    Memo1: TMemo;
    ListBox2: TListBox;
    ListBox3: TListBox;
    ScrollBox1: TScrollBox;
    Button2: TButton;
    Button3: TButton;
    RichEdit1: TRichEdit;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button11Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TestForm: TTestForm;

implementation

{$R *.dfm}

uses
  memorymanager, filediff, folderdiff,treedist, about;

function func_listNode(node: TNode): boolean;
begin
  TestForm.ListBox1.AddItem(IntToStr(node.data),node);
  TestForm.TreeView1.Items.AddChild(nil,'test');
  TestForm.TreeView1.Items.AddChild(nil,'test2');
  TestForm.TreeView1.Items.AddChild(nil,'test3');
  result := true;
end;

procedure dbgmem;
var S: xString;
begin
  S := '(diff: ' + IntToStr(fp.getmemcount - fp.freememcount) + ')';
  TestForm.ListBox1.addItem(S,nil);
  S := 'Freed ' + IntToStr(fp.freememcount) + ' out of ' + IntToStr(fp.getmemcount) + ' allocated' + S;
  writeln(S);
  Finalize(S);
end;

procedure TTestForm.Button1Click(Sender: TObject);
var T: TTree;
    node: TNode;
    A: array of TNode;
    i,pos: Integer;
    TFR,TFR2: TSimpleFileReader;
    c: char;
    b: boolean;
    S: xString;
    chset: TCharSet;
    settb: TSetTable;
    gfl: TGrammarFileLexer;
    c1: WideChar;
    c2: AnsiChar;
    s1: WideString;
    s2: AnsiString;
    qs: TQueueStack;
    X: TNFA;
    LL: TLexer;
    st1,st2: PTAState;
    token: TToken;
    pt: PToken;
begin
  c1 := #10;
  c2 := #10;
  if AnsiChar(c1) <> c2 then exit;
  s1 := '#10';
  s2 := '#10';
  if s1 <> s2 then exit;


  node := TNode.create(7);
  T := TTree.create(node);
  T.addChild(node,TNode.create(9));
  T.addChild(node,TNode.create(4));
  T.addSibling(node,TNode.create(55));

  T.preorderWalk(T.root,func_listNode);
  T.listindentedSubTree(T.root);
  T.preorderlistSubTreeInTreeView(T.root,TestForm.TreeView1,nil);

  T.calculateSizeInSubTree(T.root,0);
  SetLength(A,T.getSize);
  T.preorderfillSubTreeToArray(T.root,A);
  for i := 0 to Length(A) - 1 do begin
    ListBox1.AddItem(A[i].toString + '<--' + IntToStr(A[i].size),A[i]);
  end;

  T.Free;
  A := nil;

  S := '';
  Memo1.Text := '';
  TFR := TSimpleFileReader.create;
  b := TFR.open(FCurrentDirectory + 'test\' + 't3.grm');
  if (b) then while (not TFR.atEOF) do begin
    if not b then
      writeLn('Error: Token too large (rollback impossible)');
    b := TFR.readChar(c);
    S := S + c;
    write(c);
  end;
  TFR.Free;

  Memo1.Text := S;

  chset := TCharSet.create('WS');
  chset.addString(SET_Number);
  if chset.hasChar('1') then
    TestForm.caption := chset.toString;

  settb := TSetTable.create;
  settb.add(chset);
  chset.add('=');
  settb.Free;

  TFR := TSimpleFileReader.create;
  b := TFR.open(FCurrentDirectory + 'test\' + 't3.grm');
  if b then begin
    gfl := TGrammarFileLexer.create(TFR);
    ListBox2.AddItem('Tokens:',nil);
    repeat
      S := gfl.getNextToken(i);
      S := IntToStr(i) + ': ' + S;
      ListBox2.AddItem(S,nil);
    until TFR.EOF;
    S := gfl.getNextToken(i);     //    EOF TOKEN
    S := IntToStr(i) + ': ' + S;
    ListBox2.AddItem(S,nil);
    gfl.Flog.updateListBox(ListBox3);
    gfl.Free;
  end;
  TFR.Free;

//  ShowMessage('test');

  TFR2 := TSimpleFileReader.create;
  b := TFR2.open(FCurrentDirectory + 'test\' + 't5.txt');

  TFR := TSimpleFileReader.create;
  b := TFR.open(FCurrentDirectory + 'test\' + 't5.grm');

  if b then begin
    gfl := TGrammarFileLexer.create(TFR);
    gfl.parse;
    X := gfl.getNFA;
    gfl.Flog.updateListBox(ListBox3);

    LL := TLexer.create(TFR2,X);
    repeat
//      S := LL.getToken(i,pos);
      pt := LL.getToken;
      i := pt.tokentype;
      S := '(' + IntToStr(pt.startp) + ' - ' + IntToStr(pt.endp) + ')_|_-> ' + pt.value + ' (' + IntToStr(i) + ')';
      dispose(pt);
      writeln(S);
      ListBox2.AddItem(S,nil);
//      LL.FNFA.startSimulation;
    until i = L_EOF;//TFR.EOF;
    LL.Free;

    writeln('!!!!!!!!!!!!!!!!!!!!!!!!!');
//    writeln(gfl.resolveEscSeq('\9\65\9\66\\\\\67\\9'));
    writeln('!!!!!!!!!!!!!!!!!!!!!!!!!');

    gfl.Free;
  end;
  TFR.Free;

  TFR2.Free;

//  exit;
//  writeln('!!!!!!!!!!!!!!!!!!!!'+ EOL + X.toString);

  qs := TQueueStack.create;
  qs.enqueue(10);
  qs.enqueue(11);
  qs.enqueue(12);
  qs.enqueue(13);
(*  while not qs.isEmpty do begin
    i := qs.peekNext;
    if i = -1 then break;
    S := IntToStr(i);
    write(S+' ');
  end;*)
  while not (qs.getCurrentNode = qs.getLastNode) do begin
    i := qs.peekNext;
//    if i = -1 then break;
    S := IntToStr(i);
    write(S+' ');
  end;
  qs.pop;
  qs.pop;
  qs.pop;
  qs.pop;
  qs.pop;
  qs.pop;
  writeln(qs.toString);
  qs.Free;

  X := TNFA.create;
  st1 := X.addStateEx(0);
  st2 := X.addStateEx(L_T_BEGIN);
  X.addlinksEx(st1,st2,ord('A'),LT_CHAR);
  X.addlinksEx(st2,st1,ord('X'),LT_CHAR);
  X.setCaseSensitivity(false);

  writeln(X.toString);

  TFR := TSimpleFileReader.create;
  b := TFR.open(FCurrentDirectory + 'test\' + 'tt.txt');
  if b then begin
    LL := TLexer.create(TFR,X);
    repeat
      pt := LL.getToken;
      S := pt.value;
      i := pt.tokentype;
      pos := pt.startp;
      S := IntToStr(pos) + '_|_-> ' + S + ' (' + IntToStr(i) + ')';
      writeln(S);
      ListBox2.AddItem(S,nil);
//      LL.FNFA.startSimulation;
    until i = L_EOF;//TFR.EOF;
    LL.Free;
  end;
  TFR.Free;


(*  TFR := TSimpleFileReader.create;
  b := TFR.open(FCurrentDirectory + 'test\' + 'tt.txt');
  if b then begin
    repeat
      TFR.readChar(c);
      writeln(TFR.getPosition);
      TFR.unreadChar2;
      writeln(TFR.getPosition);
      TFR.readChar(c);
      writeln(TFR.getPosition);
      writeln('------------');
    until TFR.EOF;
  end;
  TFR.Free;*)

  X.Free;
end;

procedure TTestForm.Button2Click(Sender: TObject);
var I: Integer;
    TerminalNameTable: TStrIntHashMap;
    TTT: TStrIntHashMap;
    IHS: TIntHashSet;
    b: Boolean;
    SL: TSortedDLinkedList;
    x: PSListNode;
    L: PIntList;
    ln: PIntNode;
begin
  L := newlist;
  appendInteger(L,10);
  appendInteger(L,2);
  appendInteger(L,17);
  appendInteger(L,4);
  appendInteger(L,76);
  appendInteger(L,43);
  ln := L.head;
  writeln('LIST============');
  while ln <> nil do begin
    writeln(ln.i);
    ln := ln.next;
  end;
  freelist(L);
  SL := TSortedDLinkedList.create;
  SL.add(2,0,7,4,4);
  SL.add(5,1,1,5,4);
  SL.add(6,2,1,7,4);
  SL.add(3,3,1,6,4);
  SL.add(8,4,1,3,4);
  SL.add(1,5,1,3,4);
  SL.add(5,1,1,6,4);
  SL.add(6,2,1,0,4);
  SL.add(3,3,1,9,4);
  SL.add(8,4,1,8,4);
  SL.add(1,5,1,8,4);
  SL.add(5,1,1,7,4);
  SL.add(6,2,1,6,4);
  SL.add(3,3,1,2,4);
  SL.add(8,4,1,3,4);
  SL.add(1,5,1,4,4);

  SL.getNextReset;
  while SL.getNext(x) do begin
    writeln(x.key,' ',x.data,' ',x.tag1,' ',x.tag2);
  end;

  SL.Free;

  TerminalNameTable := TStrIntHashMap.create;
  TerminalNameTable.toString;

  IHS := TIntHashSet.create(true);
  IHS.add(7);
  IHS.add(4);
  IHS.add(6);
  IHS.add(8);
  IHS.add(9);
  IHS.add(3);
  IHS.add(3);
  IHS.add(3);
  IHS.add(14);
  IHS.add(15);
  IHS.add(16);
  IHS.add(17);
  IHS.add(18);
  IHS.add(19);
  IHS.add(20);
  IHS.add(7);
  IHS.add(7);
  IHS.add(20);
  IHS.add(7);
  writeln('##########');
  writeln(IHS.toString(true));

  IHS.removeAll(3);
  IHS.removeAll(7);
  IHS.remove(20);
  IHS.removeAll(7);
  IHS.remove(7);

  IHS.getNextReset;
  while IHS.getNext(I) do
    write(IntToStr(I) + ' ');

  writeln;
  writeln('##########');
  writeln(IHS.toString(true));
  IHS.Free;

  with TerminalNameTable do begin
    add('Identifier',1,-1);
    add('String',2,-1);
    add('if',3,-1);
    add('else',4,-1,'{{{{else}}}}');
    add('then',5,-1);
    add('then',5,-1);
    add('then',5,-1);
    add('then',5,-1);
    add('then',5,-1);
//    writeln(toString);
    remove('Identifier');
//    writeln(toString);
//    remove('Identifier');
//    writeln(toString);
    add('Identifier',1,-1);
    writeln(toString);
    writeln(findByValue(5,b));
  end;
  TTT := TerminalNameTable;
  writeln(TTT.findByKey('then',b));
  writeln(TTT.findByKey('if',b));
  writeln(TTT.toString(true));
  TTT.free;

//  about.AboutBox.ShowModal;
end;

procedure TTestForm.Button3Click(Sender: TObject);
var WideS: WideString;
    AnsiS: AnsiString;
    S: xString;
    TF: TFont;
begin
  SetCurrentLang(1 - GetCurrentLang);
//  WideS := UTF8Decode(GetLangString(1003));
//  AnsiS := WideS;
//  AnsiS := UTF8ToAnsi(GetLangString(1003));
//  WideS := GetLangString(1003);
//  AnsiS := GetLangString(1003);
//  S := UTF8Decode(WideS);
//  S := WideStringToString(WideS,28592);//EASTEUROPE_CHARSET);//1250);//CP_ACP);
//  ShowMessage(WideS);
//  ShowMessage(S);
//  MessageBoxW(0,PWideChar(WideS),PWideChar(WideS),MB_OK);
  S := GetLangString(0);
  TestForm.Caption := S;

  SetCurrentLang(1 - GetCurrentLang);
  S := GetLangString(99);
  Button1.Caption := S;
  SetCurrentLang(1 - GetCurrentLang);
//  TF := TFont.Create;
//  TF := TestForm.Font;
(*  with TestForm.Font do begin
    Charset := 238;
    Name := 'Lucida Console';
  end;*)
//  TestForm.Font := TF;
(*  TestForm.Canvas.TextOut(0,272,TestForm.Font.Name + #$BE#$9A#$E8#$9D#$9E#$FD);
  TestForm.Caption := TestForm.Font.Name + #$BE#$9A#$E8#$9D#$9E#$FD;*)
end;

procedure TTestForm.Button4Click(Sender: TObject);
const
  COUNTRY_CODE_3 = 'SKY';
var
  i : Integer;

  d: DWORD;
  buffer: array [0..6] of ansiChar;
  CodePage : DWORD;
  cs : TCharsetInfo;
  charset : TFontCharset;
begin


  for i := 0 to Languages.Count - 1 do
    if Languages.Ext [i] = COUNTRY_CODE_3 then
    begin
      GetLocaleInfo(Languages.LocaleID [i], LOCALE_IDEFAULTANSICODEPAGE, buffer, SizeOf(buffer));
      CodePage := StrToIntDef(Buffer, GetACP);
      Win32Check (TranslateCharsetInfo (CodePage, cs, TCI_SRCCODEPAGE));
      charset := cs.ciCharset;

      ShowMessage (Format ('Use TFontCharset=%d for ' + COUNTRY_CODE_3, [charset]))
    end
end;

procedure TTestForm.Button5Click(Sender: TObject);
begin
  TestForm.Caption := 'Freed ' + IntToStr(fp.freememcount) + ' out of ' + IntToStr(fp.getmemcount) + ' allocated (diff: ' + IntToStr(fp.getmemcount - fp.freememcount) + ')';
end;

procedure TTestForm.Button6Click(Sender: TObject);
var TFR,TFR2: TSimpleReader;
    i,pos: Integer;
    c: char;
    b: boolean;
    S: xString;
    gfl: TGrammarFileLexer;
    pb: TParserBuilder;
    X: TNFA;
    LL: TLexer;
    pt: PToken;
    parser: TParser;
    root1: PToken;
    lexer_build_time: Integer;
    parser_build_time: Integer;
    tree_build_time: Integer;
    size1,size2: Integer;
begin
  S := '';
  Memo1.Text := '';
  TFR := TSimpleFileReader.create;
  b := TFR.open(FCurrentDirectory + 'test\' + 't7.grm');
  if (b) then while (not TFR.atEOF) do begin
    if not b then
      writeLn('Error: Token too large (rollback impossible)');
    b := TFR.readChar(c);
    S := S + c;
    write(c);
  end;
  TFR.Free;

  S := S + EOL + '-------------------------' + EOL;
//  Memo1.Text := S;

  S := '';

//  Memo1.Text := 'test';
  TFR := TSimpleStringReader.create;
  b := TFR.open('STRING',Memo1.Text);
  if (b) then while (not TFR.atEOF) do begin
    if not b then
      writeLn('Error: Token too large (rollback impossible)');
    b := TFR.readChar(c);
    S := S + c;//AnsiUpperCase(c);
    write(c);
  end;
  TFR.Free;

  Memo1.Text := S;

//  TFR := TSimpleStringReader.create;
//  b := TFR.open('Som zvedavy',Memo1.Text);//FCurrentDirectory + 'test\' + 't5.grm');
  TFR := TSimpleFileReader.create;
//  b := TFR.open(FCurrentDirectory + 'test\' + 'pascal2.grm');
  b := TFR.open(FCurrentDirectory + 'test\' + 't5.grm');

  if b then begin
    gfl := TGrammarFileLexer.create(TFR);
    lexer_build_time := getcurrenttime;
    gfl.parse;
    lexer_build_time := getcurrenttime - lexer_build_time;
    gfl.Flog.updateListBox(ListBox3);

    Memo1.Text := Memo1.Text + gfl.getNFA.FSetTable.toString;
    Memo1.Text := Memo1.Text + gfl.getTokenNameTypeTable.toString(true);
    Memo1.Text := Memo1.Text + gfl.getStateNameTypeTable.toString(true);
    Memo1.Text := Memo1.Text + gfl.FRuleTable.toString(true,gfl.getTokenNameTypeTable,gfl.getStateNameTypeTable);
//    LR := pb.getLR;
    writeln('&&&&&&&&&&&&&&&&&&' + EOL + gfl.getRuleTable.toString(true,gfl.getTokenNameTypeTable,gfl.getStateNameTypeTable));

    TFR2 := TSimpleFileReader.create;
//    b := TFR2.open(FCurrentDirectory + 'test\' + 'pascaltest.pas');
    b := TFR2.open(FCurrentDirectory + 'test\' + 't5test.txt');
    if b then begin
      X := gfl.getNFA;
      LL := TLexer.create(TFR2,X);

      pb := TParserBuilder.create(LL,gfl.getTokenNameTypeTable,gfl.getStateNameTypeTable,gfl.getRuleTable);
//      pb := TParserBuilder.create(LL,nil,nil,gfl.getRuleTable);

//      writeln(gfl.FRuleTable.toString(true));
      parser_build_time := getcurrenttime;
      pb.buildLALRParser;
      parser_build_time := getcurrenttime - parser_build_time;

      parser := pb.getParser;
      pb.free;

//      writeln(parser.toString);  //strasne pomale!!!!!!!!!!!!!

      tree_build_time := getcurrenttime;
      parser.parse(root1,size1);
      tree_build_time := getcurrenttime - tree_build_time;

      parser.free;

      Memo1.Text := Memo1.Text + toStringSubTree(root1,false,true,true,gfl.getTokenNameTypeTable,gfl.getStateNameTypeTable);
(*
      repeat
//        S := LL.getToken(i,pos);
//        S := '(' + IntToStr(pos) + ' - ' + IntToStr(pos+Length(S)-1) + ')_|_-> ' + S + ' (' + IntToStr(i) + ')';

        pt := LL.getToken;
        i := pt.tokentype;
        writeln('# ' + IntToStr(Length(pt.value)) + ' #' + pt.value);
        S := '(' + IntToStr(pt.startp) + ' - ' + IntToStr(pt.endp) + ')_|_-> ' + pt.value + ' (' + IntToStr(i) + ')';
        if pt <> nil then
          dispose(pt);
        pt := nil;
        writeln(S);
        ListBox2.AddItem(S,nil);
      until i = L_EOF;
*)
      LL.Free;
    end;
    TFR2.Free;

//    writeln('!!!!!!!!!!!!!!!!!!!!!!!!!');
//    writeln(gfl.resolveEscSeq('\9\65\9\66\\\\\67\\9'));
//    writeln('!!!!!!!!!!!!!!!!!!!!!!!!!');

    gfl.Free;
  end;
  TFR.Free;



  writeln('Lexer build time: ' + IntToStr(lexer_build_time));
  writeln('Parser build time: ' + IntToStr(parser_build_time));
  writeln('Parse tree build time: ' + IntToStr(tree_build_time));
end;

procedure TTestForm.Button7Click(Sender: TObject);
var TFR,TFR2,TFR3: TSimpleReader;
    i,pos: Integer;
    c: char;
    b: boolean;
    S: xString;
    gfl: TGrammarFileLexer;
    pb: TParserBuilder;
    X: TNFA;
    DFA: TDFA;
    LL: TLexer;
    pt: PToken;
    parser: TParser;
    root1,root2: PToken;
    lexer_build_time: Integer;
    parser_build_time: Integer;
    tree_build_time: Integer;
    tree_build_time2: Integer;
    DFA_build_time: Integer;
    size1,size2: Integer;
    L: PIntList;
begin
  TFR := TSimpleFileReader.create;
//  b := TFR.open(FCurrentDirectory + 'test\' + 'j20.grm');
//  b := TFR.open(FCurrentDirectory + 'test\' + 'HTML2.grm');
//  b := TFR.open(FCurrentDirectory + 'test\' + 'pascal2.grm');
  b := TFR.open(FCurrentDirectory + 'test\' + 'delphi10.grm');

  if b then begin
    gfl := TGrammarFileLexer.create(TFR);

    lexer_build_time := getcurrenttime;
    gfl.parse;
    lexer_build_time := getcurrenttime - lexer_build_time;

    gfl.Flog.updateListBox(ListBox3);
(*
    Memo1.Text := Memo1.Text + gfl.getNFA.FSetTable.toString;
    Memo1.Text := Memo1.Text + gfl.FTokenNameTypeTable.toString(true);
    Memo1.Text := Memo1.Text + gfl.FStateNameTypeTable.toString(true);
    Memo1.Text := Memo1.Text + gfl.FRuleTable.toString(true,gfl.FTokenNameTypeTable,gfl.FStateNameTypeTable);
*)
    TFR3 := TSimpleFileReader.create;
    b := TFR3.open(FCurrentDirectory + 'test\' + 'delphi1.pas');
//    b := TFR3.open(FCurrentDirectory + 'test\' + 'j20.java');
//    b := TFR3.open(FCurrentDirectory + 'test\' + 'p3.pas');
//    b := TFR3.open(FCurrentDirectory + 'test\' + 'HTMLtest2.html');
    TFR2 := TSimpleFileReader.create;
    b := TFR2.open(FCurrentDirectory + 'test\' + 'delphi1.pas');
//    b := TFR2.open(FCurrentDirectory + 'test\' + 'j21.java');
//    b := TFR2.open(FCurrentDirectory + 'test\' + 'p.pas');
//    b := TFR2.open(FCurrentDirectory + 'test\' + 'pascaltest.pas');
//    b := TFR2.open(FCurrentDirectory + 'test\' + 'HTMLtest1.html');
    if b then begin
      X := gfl.getNFA;

      DFA := TDFA.create(X);
      DFA_build_time := getcurrenttime;
      b := DFA.build3;
      DFA_build_time := getcurrenttime - DFA_build_time;

      LL := TLexer.create(TFR2,X,DFA);
      pb := TParserBuilder.create(LL,gfl.getTokenNameTypeTable,gfl.getStateNameTypeTable,gfl.getRuleTable);

      parser_build_time := getcurrenttime;
      pb.buildLALRParser;
      parser_build_time := getcurrenttime - parser_build_time;

      parser := pb.getParser;
      pb.free;

      tree_build_time := getcurrenttime;
      parser.parse(root1,size1);
      tree_build_time := getcurrenttime - tree_build_time;

      LL.LFileReader := TFR3;

      tree_build_time2 := getcurrenttime;
      parser.parse(root2,size2);
      tree_build_time2 := getcurrenttime - tree_build_time2;

      Memo1.Text := '';
      Memo1.Text := Memo1.Text + toStringSubTree(root1,false,true,true,gfl.getTokenNameTypeTable,gfl.getStateNameTypeTable);
      Memo1.Text := Memo1.Text + toStringSubTree(root2,false,true,true,gfl.getTokenNameTypeTable,gfl.getStateNameTypeTable);

      //

      TestForm.Caption := IntToStr(comparetrees3(root1,size1,root2,size2,GFL.getRuleTable,L).score);

      Memo1.Text := Memo1.Text + '!!!!!!!!!!!!!!!!!!' + EOL + '@@@@@@@@@@@@@@@@@@' + EOL;
      Memo1.Text := Memo1.Text + toStringSubTree(root1,false,false,true,gfl.getTokenNameTypeTable,gfl.getStateNameTypeTable);
      Memo1.Text := Memo1.Text + toStringSubTree(root2,false,false,true,gfl.getTokenNameTypeTable,gfl.getStateNameTypeTable);

      Memo1.Text := Memo1.Text + (gfl.getTokenNameTypeTable.toString(true));
      Memo1.Text := Memo1.Text + (gfl.getStateNameTypeTable.toString(true));
(*
      ParseTreeToString(root1);
      writeln;
      ParseTreeToString(root2);
      writeln;
*)
      //

      freeSubTree(root1);
      freeSubTree(root2);

      parser.Free;
      LL.Free;
      DFA.Free;
    end;
    TFR2.Free;
    gfl.Free;
  end;
  TFR3.Free;
  TFR.Free;

  writeln('.grm Parsing and NFA build time: ' + IntToStr(lexer_build_time));
  writeln('Converting to DFA time: ' + IntToStr(DFA_build_time));
  writeln('Parser build time: ' + IntToStr(parser_build_time));
  writeln('Parse tree1 build time: ' + IntToStr(tree_build_time));
  writeln('Parse tree2 build time: ' + IntToStr(tree_build_time2));
end;

procedure TTestForm.Button10Click(Sender: TObject);
var TFR,TFR2: TSimpleFileReader;
    b: Boolean;
    gfl: TGrammarFileLexer;
    LL: TLexer;
    pt: PToken;
    i,j,index: Integer;
    S: xString;
    X: TNFA;
    lexer_build_time: Integer;
    DFA_build_time: Integer;
    NFA_tokenization_time: Integer;
    DFA_tokenization_time: Integer;
    c: char;
    DFA: TDFA;
    SA: array of char;
    count,allocated: Integer;
begin
  TFR := TSimpleFileReader.create;
//  b := TFR.open(FCurrentDirectory + 'test\' + 'delphi.grm');
//  b := TFR.open(FCurrentDirectory + 'test\' + 't5.grm');
  b := TFR.open(FCurrentDirectory + 'test\' + 'delphi11.grm');

  if b then begin
    TFR2 := TSimpleFileReader.create;
//    b := TFR2.open(FCurrentDirectory + 'test\' + 'delphitest.pas');
//    b := TFR2.open(FCurrentDirectory + 'test\' + 't5.txt');
    b := TFR2.open(FCurrentDirectory + 'filereader.pas');
    if b then begin
      gfl := TGrammarFileLexer.create(TFR);
      lexer_build_time := getcurrenttime;
      gfl.parse;
      lexer_build_time := getcurrenttime - lexer_build_time;
      X := gfl.getNFA;
//      writeln(X.toString);

      gfl.Flog.updateListBox(ListBox3);
  (*
      Memo1.Text := Memo1.Text + gfl.getNFA.FSetTable.toString;
      Memo1.Text := Memo1.Text + gfl.FTokenNameTypeTable.toString(true);
      Memo1.Text := Memo1.Text + gfl.FStateNameTypeTable.toString(true);
      Memo1.Text := Memo1.Text + gfl.FRuleTable.toString(true,gfl.FTokenNameTypeTable,gfl.FStateNameTypeTable);
  *)
//      Memo1.Text := X.toString(true);

      LL := TLexer.create(TFR2,X);
      NFA_tokenization_time := getcurrenttime;
  {    repeat
        TFR2.readChar(c);
  //      write(c);
      until TFR2.atEOF;}

      repeat

  //      S := LL.getToken(i,pos);
        pt := LL.getToken;
        i := pt.tokentype;
(*
        S := '(' + IntToStr(pt.startp) + ' - ' + IntToStr(pt.endp) + ')_|_-> ' + pt.value + ' (' + IntToStr(i) + ')';
//        writeln(S);
        ListBox2.AddItem(S,nil);
*)
        dispose(pt);
  //      LL.FNFA.startSimulation;

      until i = L_EOF;//TFR.EOF;
      NFA_tokenization_time := getcurrenttime - NFA_tokenization_time;
      LL.Free;

    end;
  end;
  TFR.Free;

  TFR2.Free;

  TFR2 := TSimpleFileReader.create;
  b := TFR2.open(FCurrentDirectory + 'filereader.pas');
  if b then begin

    DFA := TDFA.create(X);

    DFA_build_time := getcurrenttime;
    b := DFA.build3;
    DFA_build_time := getcurrenttime - DFA_build_time;

    Memo1.Text := DFA.toString;

    LL := TLexer.create(TFR2,X,DFA);
    DFA_tokenization_time := getcurrenttime;
    if b then
      repeat
        pt := LL.getToken;
        i := pt.tokentype;

        S := 'DFA :: (' + IntToStr(pt.startp) + ' - ' + IntToStr(pt.endp) + ')_|_-> ' + pt.value + ' (' + IntToStr(i) + ')';
//        writeln(S);
        ListBox2.AddItem(S,nil);
        Memo1.Lines.Add(S);

        dispose(pt);
      until i = L_EOF;//TFR.EOF;
(*      allocated := 32;
      SetLength(SA,allocated);
      count := 0;
      index := 0;*)
{      I := 0;
      repeat
        if LL.LFileReader.readChar(c) then
          I := I + 1;
        new(pt);
//        I := TSimpleFileReader(LL.LFileReader).getPos;
        J := TSimpleFileReader(LL.LFileReader).getPosition;
//        writeln(I,' = ',J);
        if DFA.simulate(c) = -1 then begin
          DFA.reset;
          clearGCA;
          toStringGCA(S);
//          SetLength(S,index);
//          FastCharMove(SA[0],S[1],index);
////          for J := 1 to index do
////            S[J] := SA[J-1];
//          index := 0;
        end
        else begin
          addtoGCA(c);
//          SA[index] := c;
//          index := index + 1;
//          if index = allocated then begin
//            allocated := allocated * 4;
//            SetLength(SA,allocated);
//          end;
        end;
        dispose(pt);

//        S := '(' + IntToStr(pt.startp) + ' - ' + IntToStr(pt.endp) + ')_|_-> ' + pt.value + ' (' + IntToStr(i) + ')';
//       writeln(S);
//        ListBox2.AddItem(S,nil);


      until LL.LFileReader.atEOF;//i = L_EOF;//TFR.EOF;
(*      SA := nil;*)}

    DFA_tokenization_time := getcurrenttime - DFA_tokenization_time;

    LL.Free;
    DFA.Free;
  end;
  TFR2.Free;

  gfl.Free;

  writeln('.grm Parsing and NFA build time: ' + IntToStr(lexer_build_time));
  writeln('Converting to DFA time: ' + IntToStr(DFA_build_time));
  writeln('NFA Tokenization of input file time: ' + IntToStr(NFA_tokenization_time));
  writeln('DFA Tokenization of input file time: ' + IntToStr(DFA_tokenization_time));
end;


procedure TTestForm.Button9Click(Sender: TObject);
begin
  FileDiffForm.Show;
end;

procedure TTestForm.Button8Click(Sender: TObject);
begin
  FolderDiffForm.Show;
end;

procedure TTestForm.Button11Click(Sender: TObject);
begin
//  testDiff;
end;

procedure TTestForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
//  Application.Terminate;
end;

end.

//10.12 - 6
//11.12 - 10
//12.12 - 2
//13.12 - 0
//14.12 - 0
//15.12 - 0
//16.12 - 0
//17.12 - 0
//18.12 - 9
//19.12 - 1
//20.12 - 0
//21.12 - 8
//22.12 - 7
//23.12 - 0
//24.12 - 0
//25.12 - 4
//26.12 - 1
//27.12 - 0
//28.12 - 0
//29.12 - 1
//30.12 - 0
//31.12 - 0

//**.12 - 49

//01.01 - 0
//02.01 - 0
//03.01 - 0
//04.01 - 0
//05.01 - 0
//06.01 - 0
//07.01 - 0
//08.01 - 0
//09.01 - 0
//10.01 - 1
//11.01 - 11
//12.01 - 8
//13.01 - 2
//14.01 - 0
//15.01 - 0
//16.01 - 0
//17.01 - 2
//18.01 - 1
//19.01 - 0
//20.01 - 4
//21.01 - 7
//22.01 - 6
//23.01 - 1
//24.01 - 1
//25.01 - 1
//26.01 - 7
//27.01 - 14
//28.01 - 4
//29.01 - 10
//30.01 - 11
//31.01 - 10

//**.01 - 101

//01.02 - 4
//02.02 - 1
//03.02 - 1
//04.02 - 4
//05.02 - 5
//06.02 - 6
//07.02 - 1
//08.02 - 2
//09.02 - 4
//10.02 - 0
//11.02 - 8
//12.02 - 1
//13.02 - 2
//14.02 - 8
//15.02 - 13
//16.02 - 14
//17.02 - 15
//18.02 - 12
//19.02 - 15
//20.02 - 9
//21.02 - 15
//22.02 - 12
//23.02 - 4
//24.02 - 16
//25.02 - 10
//26.02 - 18
//27.02 - 12
//28.02 - 10

//**.02 - 222

//01.03 - 10
//02.03 - 10
//03.03 - 18
//04.03 - 10
//05.03 - 4
//06.03 - 10
//07.03 - 14
//08.03 - 15
//09.03 - 12
//10.03 - 12
//11.03 - 4
//12.03 - 6
//13.03 - 6
//14.03 - 10
//15.03 - 10
//16.03 - 12
//17.03 - 12
//18.03 - 4
//19.03 - 4
//20.03 - 12
//21.03 - 10
//22.03 - 8
//23.03 - 16
//24.03 - 12
//25.03 - 12
//26.03 - 12
//27.03 - 14
//28.03 - 14

//**.03 - 293

//01.04 - 6
//02.04 - 6
//03.04 - 14
//04.04 - 19
//05.04 - 20
//06.04 - 20
//07.04 - 12
//08.04 - 10
//09.04 - 18
//10.04 - 12
//11.04 - 18
//12.04 - 20
//13.04 - 21
//14.04 - 4

//**.04 - 200

//**.** - 49 + 101 + 222 + 293 = 663 + 200 = 863
