/****************************************************************************
*                tpl.h
*
*  Copyright 2003, 2004, 2005 Tomas Plachetka
*
*****************************************************************************/

#ifndef TPL_H
#define TPL_H

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

/*****************************************************************************
* Global typedefs
******************************************************************************/

typedef int MATCHING_FUNC(int sender, int tag, void *message);

/*****************************************************************************
* Global variables
******************************************************************************/

/*****************************************************************************
* Global functions
******************************************************************************/

void tpl_initialize(int *nr_tasks, int *rank, int *argc, char ***argv);
void tpl_deinitialize(void);

void tpl_register_function(MATCHING_FUNC *function, char *function_name);

void tpl_send(int *recipients, int nr_recipients, int tag, void *message);
void tpl_recv(MATCHING_FUNC *match, int *sender, int *tag, void **message);

void tpl_create(void **message);
void tpl_destroy(void *message);

void tpl_pkbyte(void *message, void *p, int nitems);
void tpl_upkbyte(void *message, void *p, int nitems);
void tpl_pkchar(void *message, char *p, int nitems);
void tpl_upkchar(void *message, char *p, int nitems);
void tpl_pkdouble(void *message, double *p, int nitems);
void tpl_upkdouble(void *message, double *p, int nitems);
void tpl_pkfloat(void *message, float *p, int nitems);
void tpl_upkfloat(void *message, float *p, int nitems);
void tpl_pkint(void *message, int *p, int nitems);
void tpl_upkint(void *message, int *p, int nitems);
void tpl_pklong(void *message, long *p, int nitems);
void tpl_upklong(void *message, long *p, int nitems);
void tpl_pklongdouble(void *message, long double *p, int nitems);
void tpl_upklongdouble(void *message, long double *p, int nitems);
void tpl_pkshort(void *message, short *p, int nitems);
void tpl_upkshort(void *message, short *p, int nitems);
void tpl_pkuchar(void *message, unsigned char *p, int nitems);
void tpl_upkuchar(void *message, unsigned char *p, int nitems);
void tpl_pkuint(void *message, unsigned int *p, int nitems);
void tpl_upkuint(void *message, unsigned int *p, int nitems);
void tpl_pkulong(void *message, unsigned long *p, int nitems);
void tpl_upkulong(void *message, unsigned long *p, int nitems);
void tpl_pkushort(void *message, unsigned short *p, int nitems);
void tpl_upkushort(void *message, unsigned short *p, int nitems);

#endif

