/* ************************************************************************** */
/* *************************** list of process' ***************************** */
/* ************************************************************************** */

#include <malloc.h>
#include "message_list.h"

#define BLOCK_LIST_C
	#include "process_list_inc.h"
#undef BLOCK_LIST_C

/* callback function after creating process in list */
void process_list_Create_Callback(process_search_data *Item)
{
	process_data *process;

	process = (process_data *) malloc(sizeof(process_data));

	if ( process != NULL )
	{
		Item->process = process;

		process->cdata = NULL;
		process->tdata = NULL;
		process->message_list = NULL;
	}
	else
	{
		Item->process = NULL;
	}
}

/* callback function before deleting process from list */
void process_list_Delete_Callback(process_search_data *Item)
{
	if ( Item->process != NULL)
	{
		if (Item->process->message_list != NULL)
		{
			message_list_DeleteAll(&(Item->process->message_list));
		}

		free(Item->process);
		Item->process = NULL;
	}
}
