/****************************************************************************
*                work.c
*
*  Copyright 2005, Tomas Plachetka
*
*****************************************************************************/

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
/* #include <values.h> */
#include <sys/time.h>

#include "work.h"
#include "tpl.h" /* gettimeofday, ERROR */

#if defined(__MINGW32__)
	#include <sys/timeb.h>

	int get_time(struct timeval *tp)
	{
		struct timeb tb;

		ftime(&tb);

		tp->tv_sec = tb.time;
		tp->tv_usec = tb.millitm * 1000;

		return 0;
	}
#else
	#define get_time(x) gettimeofday(x, NULL)
#endif

/*****************************************************************************
* Local preprocessor defines
******************************************************************************/
#define ERROR(x) {printf(x); tpl_deinitialize(); exit(1);}

#if defined(PARIX) || defined(__MINGW32__)
#define RAND (((double) rand()) / ((double) RAND_MAX))
#define SRAND(x) srand(x)
#else
#define RAND_MAX (MAXINT - 1)
#define RAND drand48()
#define SRAND(x) srand48(x)
#endif

/*****************************************************************************
* Local typedefs
******************************************************************************/

/*****************************************************************************
* Local variables
******************************************************************************/

/*****************************************************************************
* Static functions
******************************************************************************/

/*****************************************************************************
*
* FUNCTION
*
*   work_initialize
*
* INPUT
*   
* OUTPUT
*   
* RETURNS
*
* AUTHOR
*
*   Tomas Plachetka
*   
* DESCRIPTION
*
*
* CHANGES
*
*   -
*
******************************************************************************/
void work_initialize(void)
{
  struct timeval tv;

  get_time(&tv);
  SRAND(tv.tv_usec);
}

/*****************************************************************************
*
* FUNCTION
*
*   work_deinitialize
*
* INPUT
*   
* OUTPUT
*   
* RETURNS
*
* AUTHOR
*
*   Tomas Plachetka
*   
* DESCRIPTION
*
*
* CHANGES
*
*   -
*
******************************************************************************/
void work_deinitialize(void)
{
}

/*****************************************************************************
*
* FUNCTION
*
*   work
*
* INPUT
*   
* OUTPUT
*   
* RETURNS
*
* AUTHOR
*
*   Tomas Plachetka
*   
* DESCRIPTION
*
*
* CHANGES
*
*   -
*
******************************************************************************/
double work(void f(void *), void *arg)
{
  struct timeval tv1, tv2;

  get_time(&tv1);
  f(arg);
  get_time(&tv2);
  return((tv2.tv_sec - tv1.tv_sec) + (tv2.tv_usec - tv1.tv_usec) * 
   (double) 1e-6);
}

/*****************************************************************************
*
* FUNCTION
*
*   gauss
*
* INPUT
*   
* OUTPUT
*   
* RETURNS
*
* AUTHOR
*
*   Tomas Plachetka
*   
* DESCRIPTION
*
*
* CHANGES
*
*   -
*
******************************************************************************/
double gauss(double mu, double sigma)
{
  static double gset;
  float fac, rsq, v1, v2;
  static int iset = 0;
  
  /* Use Box-Mueller method. Some say that it interferes with congruent random
     generators, oh well... */
  if (iset == 0)
  {
    do
    {
      v1 = 2.0 * RAND - 1.0;
      v2 = 2.0 * RAND - 1.0;
      rsq = v1 * v1 + v2 * v2;
    } while ((rsq >= 1.0) || (rsq == 0.0));
    fac = sqrt(-2.0 * log(rsq) / rsq);
    gset = v1 * fac;
    iset = 1;
    return(v2 * fac * sigma + mu);
  }
  else
  {
    iset = 0;
    return(gset * sigma + mu);
  }
}

/*****************************************************************************
*
* FUNCTION
*
*   empty_work
*
* INPUT
*   
* OUTPUT
*   
* RETURNS
*
* AUTHOR
*
*   Tomas Plachetka
*   
* DESCRIPTION
*
*
* CHANGES
*
*   -
*
******************************************************************************/
double empty_work(double seconds)
{
  double pause, elapsed;
  
  struct timeval tv1, tv2;

  get_time(&tv1);
  for (elapsed = 0.0; elapsed < seconds; )
  {
    get_time(&tv2);
    elapsed = (tv2.tv_sec - tv1.tv_sec) + (tv2.tv_usec - tv1.tv_usec) * 
     (double) 1e-6;
  }
  return(elapsed);
}
