#include <stdio.h>
#include <string.h>
#include "src/hmm.h"

using namespace std;

HMM hmm;

int main(int argc, char *argv[])
{
	time_t start, done_load;
	start = clock();
	
	printf("args: %d:\n", argc);
	for (int i=0; i<argc; i++) {
		printf("%s\n", argv[i]);
	}

	char hmmstr[100] = "inputs/model-drosophila.txt";
	char faseq[100] = "wrong/one_bad_chr.input";
	char label[100] = "inputs/labels.input";
	char hints[100] = "wrong/one_bad_chr.hints";
	char output[100] = "out_graphmm.txt";
	char bonuses[100] = "inputs/bonuses.input";
	int resph = -1;
	bool multiply_int = false;
	bool multiply_sqrt = false;

	for (int i=0; i<argc; i++) {
		// -m model
		if (strcmp(argv[i], "-m") == 0) {
			if (i+1>=argc) {
				printf("wrong use of -m param. exiting\n");
				return -1;
			} else {
				strcpy(hmmstr, argv[i+1]);
			}
		}
		// -i input seq
		if (strcmp(argv[i], "-i") == 0) {
			if (i+1>=argc) {
				printf("wrong use of -i param. exiting\n");
				return -1;
			} else {
				strcpy(faseq, argv[i+1]);
			}
		}
		// -l label file
		if (strcmp(argv[i], "-l") == 0) {
			if (i+1>=argc) {
				printf("wrong use of -l param. exiting\n");
				return -1;
			} else {
				strcpy(label, argv[i+1]);
			}
		}
		// -h hints file
		if (strcmp(argv[i], "-h") == 0) {
			if (i+1>=argc) {
				printf("wrong use of -h param. exiting\n");
				return -1;
			} else {
				strcpy(hints, argv[i+1]);
			}
		}
		// -o output file
		if (strcmp(argv[i], "-o") == 0) {
			if (i+1>=argc) {
				printf("wrong use of -o param. exiting\n");
				return -1;
			} else {
				strcpy(output, argv[i+1]);
			}
		}
		// -r respected hints file
		if (strcmp(argv[i], "-r") == 0) {
			if (i+1>=argc) {
				printf("wrong use of -r param. exiting\n");
				return -1;
			} else {
				resph = i+1;
			}
		}
		// -b bonus file
		if (strcmp(argv[i], "-b") == 0) {
			if (i+1>=argc) {
				printf("wrong use of -b param. exiting\n");
				return -1;
			} else {
				strcpy(bonuses, argv[i+1]);
			}
		}

		// -int (multiply bonus with number of intervals)
		if (strcmp(argv[i], "-int") == 0) {
			multiply_int = true;
		}

		// -sqrt (multiply bonus with sqrt(number of intervals))
		if (strcmp(argv[i], "-sqrt") == 0) {
			multiply_sqrt = true;
		}
	}
	
	printf("GrapHMM running with parameters: \n");
		printf("\t- hmm model file: ""%s""\n", hmmstr);
		printf("\t- seq fasta file: ""%s""\n", faseq);
		printf("\t- labels file: ""%s""\n", label);
		printf("\t- hints file: ""%s""\n", hints);
		printf("\t- output file: ""%s""\n", output);
		printf("\t- bonus file: ""%s""\n", bonuses);
		printf("\t- mulptiplying intervals: ""%s""\n", (multiply_int ? "YES" : "NO"));
		printf("\t- mulptiplying by sqrt: ""%s""\n", (multiply_sqrt ? "YES" : "NO"));
	
	int ret;
	ret = hmm.LoadHMM(hmmstr);
	if (ret == 0) printf("Model loaded succesfully.\n");
	else { printf("wrong model file!!! (error code %d) exiting\n", ret); return -1; }
	ret = hmm.SetNLoadSeqFA(faseq);
	if (ret == 0) printf("Sequence loaded succesfully.\n");
	else { printf("wrong sequence file!!! (error code %d) exiting\n", ret); return -1; }
	ret = hmm.LoadLabels(label);
	if (ret == 0) printf("Labels loaded succesfully.\n");
	else { printf("wrong label file!!! (error code %d) exiting\n", ret); return -1; }
	ret = hmm.SetNLoadHints(hints, bonuses, multiply_int, multiply_sqrt);
	if (ret == 0) printf("Hints loaded succesfully.\n");
	else { printf("wrong hints file!!! (error code %d) exiting\n", ret); return -1; }

	// output file
	ret = hmm.SetAnnoOutput(output);
	if (ret == 0) printf("Output file set sucesfully.\n");
	else { printf("wrong output file!!! (error code %d) exiting\n", ret); return -1; }

	// resp. hints file
	ret = hmm.SetHintOutput( (resph >= 0 ? argv[resph] : NULL) );
	if (ret == 0) printf("Resp. hints file set sucesfully.\n");
	else { printf("wrong resp. hints file!!! (error code %d) exiting\n", ret); return -1; }

    /*hmm.emissMatrix[0][0]->writeSimple(stdout);
    hmm.emissMatrix[0][1]->writeSimple(stdout);
    hmm.emissMatrix[0][2]->writeSimple(stdout);
    hmm.emissMatrix[0][3]->writeSimple(stdout);*/

    //printf("%s\n", hmm.stateNames[0].c_str());
/*
	printf("%d %d %d %d\n", (int)compatible(hmm.hints[4], hmm.hints[2], true),
		(int)compatible(hmm.hints[1], hmm.hints[2], true),
		(int)compatible(hmm.hints[3], hmm.hints[2], false),
		(int)compatible(hmm.hints[3], hmm.hints[2], true));
*/
	//hmm.emissMatrix[0][2]->writeSimple(stdout);
	//double res = hmm.emit(2, 6); 

	//State st = hmm.transition(hmm.startSeq, 'e', hmm.startSeq + 20);

	// compute it all...
	done_load = clock();
	printf("Loading done in %.2f sec.\n", (done_load - start)/(double)CLOCKS_PER_SEC);
	ret = hmm.ComputeAll();
	printf("Computing done in %.2f sec.\n", (clock() - done_load)/(double)CLOCKS_PER_SEC);
	
	printf("Number of done chromosome parts: %d\n", ret);
	
	return 0;
}
