#ifndef INC_HINTS_H
#define INC_HINTS_H

#define DEBUG
#include <assert.h>

#include <vector>
#include <math.h>
#include <map>

#include "hmm.h"

using namespace std;

class HMM;

extern HMM hmm;

// simple interval
struct SimpleInt {
	int beg;
	int end;
	char label;	// hint label
};

// reference to hint or position in viterbi
struct Reference {
	int state;			// state
	Reference *back;	// back pointer
	//int hint;			// hint number - to delete later (Debug reasons only)
};

// state - consist of hmm states and info for backward pass
class State {
private:

	//int hint;			// to delete

	int stateNum;		// number of states - in hint!=hmm.stateNum
	
	// conversions
	vector<int>			*conversion;		// conversion from State to normal states
	vector<int>			*backConversion;	// conversion from normal states to State
	vector<double>		*states;
	vector<Reference>	lastState;	// states to go from for backward pass				
	
public:
	State(int stateNum, vector<int> *conv = NULL, vector<int> *backConv = NULL, int index = -1);
	~State();

	double &getStat(int index);			// access the right element according to conversion
	Reference &getLastStat(int index);
	inline int getSize() { return (states == NULL ? 0 : states->size()); }

	void init();
	void deinit();
};

// hint
class Hint {
public:

	int index;		// my number in sorted array

	int number;		// my number in file
 	double bonus; 
	bool interval;
	
	// intervals
	vector<SimpleInt>	intervals;
	
	// (big) states in hint
	vector<State>		st;

	// subsets
	vector<Hint*>		subsets;

public:
	Hint(int type, double bonus, bool interval);
	void AddInterval(int start, int stop, char label);
	void finalize(int index, int stateNum);

	// compute the transition through hint
	void transition();
	void transition(int interval, unsigned int &subIndex);
	
	inline unsigned int begin() const { assert(intervals.size() > 0); return intervals[0].beg;}
	inline unsigned int end() const { assert(intervals.size() > 0); return intervals[intervals.size()-1].end; }

	// delete all except lastState references
	void deinit();

};

// if from first we can go to second (not symetric!!)
bool compatible(Hint &first, Hint &second, bool allowSubset = false);

#endif
