#ifndef INC_HMM_H
#define INC_HMM_H

#define DEBUG
#include <assert.h>
#include <stdio.h>
#include <iostream>
#include <time.h>

#include <vector>
#include <map>
#include <string>
#include <math.h>
#include <algorithm>
#include <queue>

#include "matrix.h"
#include "hints.h"

#define _CRT_SECURE_NO_WARNINGS

using namespace std;

const double MININFTY = log(0.0);

class Hint;
class State;

class HMM {
public:
	
    // states
	// note that state has label, that is NOT hint label (2 types of labels)
    int stateNum;
    vector<string>			stateNames;		// big names of states
    vector<char>			stateLabel;		// labels of states
    map<string, int>		stateMap;		// map from names to state numbers
	map<char, vector<int> > stateLabelMap;	// map from labels to state numbers
	vector<int>				stateGrade;		// grade of each state

    // alphabet
    int alphabetNum;		// size of alphabet
    vector<char> alphabet;	// alphabet

    // transitions matrix (sparse format)
    vector< vector <pair <int, double> > > transMatrix;

    // emission matrices (GC content * stateNum)
    vector< vector<DoubleMatrix*> > emissMatrix;

    // DNA seq.
	unsigned int startSeq;
    vector<int> dnaSeq;
    vector<int> gcContent; // zeros

	// hints
	vector<Hint> hints;

	// labels - hints & states
	map<char, vector<char> >	hintToStateLabel;	// hint -> vector of state labels
	map<char, vector<int> >		hintToState;		// hint -> vector of state numbers (back conv. to hintToStateFull)
	map<char, vector<bool> >	allowedState;		// hint -> full vector of states 
	map<char, char>				stateToHint;		// state label -> hint label
	vector<char>				stateNumToHint;		// state number -> hint label
	map<char, vector<int> >		hintToStateFull;	// hint -> full vector of states + numbers (back conv. to hintToState)
													// (same as allowedState, but with numbers)
	// states in Viterbi
	vector<State> viterbi; 

	// name of chromosome
	string chromosome;

	// bonus for type of hints
	map<string, double>  bonuses; 

private:
	// helpers
	int dim[5]; // used in emit

public:
	// results
	vector<int>	resStates;
	vector<int> respectedHints;

private:
    bool usable;
    vector<double> start;

	// open files
	FILE *seq_input;
	FILE *hint_input;

	FILE *output;
	FILE *resp_hints;

	// multiply bonus
	bool multiply;
	bool mult_sqrt;

public:
    HMM();
    ~HMM();

    int LoadHMM(char* file);
	int SetNLoadSeqFA(char* file);  // load FASTA format 
	int LoadSeqFA();
	int LoadLabels(char* file);
	int SetNLoadHints(char* file, char* bonus, bool multiply = false, bool mult_sqrt = false);  // must be called last
	int LoadHints();  

	double emit(int state, int pos);
	
	void transition(int pos);			// transition from viterbi[pos] to viterbi[pos+1]
	void transition(int pos, Hint &hint); // and from viterbi[pos] to hint
	bool respected(Hint &hint);			// is hint respected?

	int ComputeAll();			// compute all chromosome parts
	double ComputeViterbi();	// compute one chormosome part

	// if NULL - print to terminal
	int SetAnnoOutput(char* file = NULL);		// set file for annotation output
	int PrintAnnotation();		// print annotation
		int PrintAnnotationGTF(char* file = NULL);	// print annotation in gtf format
	int SetHintOutput(char* file = NULL);		// set file for resected hints
	int PrintHints();			// print resected hints

	// next chromosome (flushes output, cleares space)
	bool NextChromosome(); 
};

#endif
