#include "matrix.h"

void DoubleMatrix::normalize()
{
  int last_dim = dimensions[order-1];
  for(int i=0; i<size; i+=last_dim) {
    double sum=0;
    for(int j=0; j<last_dim; j++) sum+=a[i+j];
    if(sum!=0.0) {
      for(int j=0; j<last_dim; j++) a[i+j]/=sum;
    }
  }
}

void DoubleMatrix::writeSimple(FILE *f) {
  fprintf(f,"\n%d %d\n",order,size);
  for(int i=0; i<order; i++) fprintf(f,"%d ",dimensions[i]);
  fprintf(f,"\n");
  for(int i=0; i<size; i++) fprintf(f,"%1.3lf ",a[i]);
  fprintf(f,"\n");
}

void DoubleMatrix::readSimple(FILE *f) {
  if (order!=0) {
    // free current allocations
    delete[] dimensions;
    delete[] a;
  }

  int ret = fscanf(f," %d %d ",&order,&size);
  assert(ret==2);
  dimensions=new int[order];
  a=new double[size];
  for(int i=0; i<order; i++) {
    ret = fscanf(f," %d ",&dimensions[i]);
    assert(ret==1);
  }
  for(int i=0; i<size; i++) {
    ret = fscanf(f," %lf ",&a[i]);
    assert(ret==1);
  }
}

bool add(int *arr, int order, int dimension) {
	for (int i=order-1; i>=0; i--) {
		if (arr[i]+1 == dimension) arr[i] = 0;
		else {
			arr[i]++;
			return true;
		}
	} 
	return false;
}

double avg(DoubleMatrix &matrix, int *arr, int dimension, int pos) {
	double res = 0.0;
	assert(arr[pos]==dimension-1);

	for (int i=0; i<dimension-1; i++) {
		arr[pos] = i;
		res += matrix[arr];
	}
	arr[pos] = dimension-1;
	return res / (double)(dimension-1);
}

void DoubleMatrix::readRecompute(FILE *f) 
{
	int *arr = new int[order];
	for (int ii=0; ii<order; ii++) arr[ii] = 0;
	int pos;
	bool recompute = false;
	double b;
	int dimension = getDimensions()[0];
	int i=0;

	int ret = fscanf(f," %lf ",&b);
	assert(ret==1);
	a[i] = b;
	i++;
	while (add(arr, order, dimension)) {
		assert(i<size);
		recompute = false;
		for (int j=order-1; j>=0; j--) {
			if (arr[j] == dimension-1) {
				recompute = true;
				pos = j;
				break;
			}
		}
		if (!recompute) {
			int ret = fscanf(f," %lf ",&b);
			assert(ret==1);
		} else {
			b = avg(*this, arr, dimension, pos);
		}
		a[i] = b;
		i++;
	}
	assert (i == size);
}

 void DoubleMatrix::logAll()
 {
	for(int i=0; i<size; i++) a[i] = log(a[i]);
 }


void IntMatrix::writeSimple(FILE *f) {
  fprintf(f,"\n%d %d\n",order,size);
  for(int i=0; i<order; i++) fprintf(f,"%d ",dimensions[i]);
  fprintf(f,"\n");
  for(int i=0; i<size; i++) fprintf(f,"%d ",a[i]);
  fprintf(f,"\n");
}

void IntMatrix::readSimple(FILE *f) {
  if (order!=0) {
    // free current allocations
    delete[] dimensions;
    delete[] a;
  }

  int ret = fscanf(f," %d %d ",&order,&size);
  assert(ret==2);
  dimensions=new int[order];
  a=new int[size];
  for(int i=0; i<order; i++) {
    ret = fscanf(f," %d ",&dimensions[i]);
    assert(ret==1);
  }
  for(int i=0; i<size; i++) {
    ret = fscanf(f," %d ",&a[i]);
    assert(ret==1);
  }
}








