

#if !defined(COCO_SCANNER_H__)
#define COCO_SCANNER_H__

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BUFFER_LENGTH (64*1024)
#define HEAP_BLOCK_SIZE 64*1024

// string handling
char* coco_string_create(const char* value);
char* coco_string_create(const char *value , int startIndex, int length);
void  coco_string_delete(char* &data);
void  coco_string_set(char* &data, const char* value);
int   coco_string_length(char* data);
bool  coco_string_endswith(char* data, char *value);
int   coco_string_indexof(char* data, char value);
int   coco_string_lastindexof(char* data, char value);
char* coco_string_append(const char* data1, const char* data2);
void  coco_string_merge(char* &data, char* value);
void  coco_string_merge(char* &data, char value);
char* coco_string_substring(char* data, int startIndex, int length);
char* coco_string_toupper(char* data);
char* coco_string_tolower(char* data);
char  coco_string_charat(char* data, int subscript);
bool  coco_string_equal(char* data1, char* data2);
int   coco_string_compareto(char* data1, char* data2);



class BitArray  
{
public:
	BitArray(int length = 0, bool defaultValue = false) ;
	BitArray(const BitArray &copy );
	~BitArray();

	int getCount();

	bool Get(int index);
	void Set(int index, bool value);
	void SetAll(bool value);
	bool Equal( const BitArray &right );
	bool operator[]( int index ) const;

	const BitArray &operator=( const BitArray &right );

	void Not();
	void And(BitArray value);
	void Or(BitArray value);
	void Xor(BitArray value);

	BitArray &Clone();

private:
	int Count;
	unsigned char* Data;
	void setMem(int length, bool value);

};

class Token  
{
public:
	int kind;     // token kind
	int pos;      // token position in the source text (starting at 0)
	int col;      // token column (starting at 0)
	int line;     // token line (starting at 1)
	char* val;    // token value
	Token *next;  // ML 2005-03-11 Peek tokens are kept in linked list

	Token();
	~Token();

};

class Buffer {
private:
	char *buf;          // input buffer
	int bufStart;       // position of first byte in buffer relative to input stream
	int bufLen;         // length of buffer
	int fileLen;        // length of input stream
	int pos;            // current position in buffer
	FILE* stream;      // input stream (seekable)
	bool isUserStream;  // was the stream opened by the user?
	
public:
	const int EoF;

	Buffer(FILE* s, bool isUserStream);
	~Buffer();
	
	void Close();
	int Read();
	int Peek();
	char* GetString(int beg, int end);
	int getPos();
	void setPos(int value);
};

class Scanner {
private:
	void *firstHeap;
	void *heap;
	void *heapTop;
	void *heapEnd;

	char EOL;
	int eofSym;
	int noSym;
	int maxT;
	int charSetSize;
	short *start;

	Token *t;         // current token
	char *tval;       // text of current token
	int tvalLength;   // length of text of current token
	int tlen;         // length of current token

	Token *tokens;    // list of tokens already peeked (first token is a dummy)
	Token *pt;        // current peek token

	int ch;           // current input character
	int pos;          // column number of current character
	int line;         // line number of current character
	int lineStart;    // start position of current line
	int oldEols;      // EOLs that appeared in a comment;
	BitArray *ignore; // set of characters to be ignored by the scanner

	void CreateHeapBlock();
	Token* CreateToken();
	void AppendVal(Token *t);

	void Init();
	void NextCh();
	void AddCh();
	bool Comment0();
	bool Comment1();

	void CheckLiteral();
	Token* NextToken();

public:
	Buffer *buffer;   // scanner buffer
	
	Scanner(char* fileName);
	Scanner(FILE* s);
	~Scanner();
	Token* Scan();
	Token* Peek();
	void ResetPeek();

}; // end Scanner



#endif // !defined(COCO_SCANNER_H__)

