#include "matrix.h"

vector<jItem> journal;

jItem makeJItem( int op, int destNdx, NUM coef, int srcNdx=-1 ){
	jItem res;
	res.op = op;
	res.destNdx = destNdx;
	res.coef = coef;
	res.srcNdx = srcNdx;
	return res;
}


bool isZero( NUM n ){
	return (n>-E_ZERO) && (n<E_ZERO);
}


bool isZero2( NUM n){
	return (n>-E_ZERO2) && (n<E_ZERO2);
}



Vector::Vector(int _size){
	size = _size;
	val = new NUM[size];
}

Vector::Vector( const Vector& v){
	size = v.size;
	val = new NUM[size];
	memcpy( val, v.val, size*sizeof(NUM) );
}


Vector::~Vector(){
	delete []val;
}

void Vector::operator = (const Vector& v){
	if(size!=v.size){
		size = v.size;
		delete []val;
		val = new NUM[size];
	}
	memcpy( val, v.val, size*sizeof(NUM) );
}

bool Vector::operator == (const Vector& v){
	if(size!=v.size)
		return false;
	for(int i=0; i<size; i++)
		if(val[i]!=v.val[i])
			return false;
	return true;
}

NUM Vector::dist(const Vector& v){
	NUM err=0;
	NUM delta=0;
	assert(size==v.size);
	for(int i=0; i<size; i++){
		delta = val[i]-v.val[i];
		err = err + delta*delta;
	}
	return err;
}

NUM Vector::sumVal(){
	int i;
	NUM sum=0;
	for(i=0; i<size; i++)
		sum += val[i];
	return sum;
}


void Vector::print2(){
	for(int i=0; i<size; i++)
		cout<<val[i];
}

int Vector::print3(NUM tol){
	int errCnt = 0;
	for( int i=0; i<size; i++ ){
		if( val[i]<0 ){
			cout<<"0";
		} else
		if( val[i]>1 ){
			cout<<"1";
		} else 
		if( fabs(val[i]-0)<tol ){
			cout<<"0";
		} else
		if( fabs(val[i]-1)<tol ){
			cout<<"1";
		} else {
			cout<<"X";
			errCnt++;
		}
	}
	return errCnt;
}

void Vector::print4(){
	int cvrt,i;
	for( i=0; i<size; i++){
		cvrt = (int)ceil((100*val[i])); 
		if(cvrt<0){
			cout<<"-";
			cvrt=-cvrt;
		}
		else
			cout<<" ";
		cout<<"0."<<cvrt/10<<cvrt%10<<" ";
	}
}

int Vector::print5(){
	NUM mx = 0;
	int ix = -1;
	int pc,i;
	for( i=0; i<size; i++){
		if(val[i]>mx){
			mx = val[i];
			ix = i;
		}
	}
	cout<<"[100% == "<<(float)((int)(100*mx))/100<<"]";
	for( i=0; i<size; i++){
		pc = (val[i]>0) ? (int)(100*val[i]/mx) : 0;
		cout<<pc<<"% ";
	}
	cout<<endl;
	return ix;
}

Vector Vector::operator , (const Vector& v){
	Vector res( size + v.size );
	int i;
	for( i=0; i<size; i++ )
		res.val[i] = val[i];
	for( i=0; i<v.size; i++ )
		res.val[size+i] = v.val[i];
	return res;
}

void Vector::print(){
	for(int i=0; i<size; i++)
		cout<<val[i]<<"\t";
	cout<<endl;
}

void Vector::addNoise(float ammount){
	int i;
	for( i=0; i<size; i++)
		val[i] = val[i] + ammount * ( 2*rand()/RAND_MAX - 1 );
}


Matrix::Matrix( int _h, int _w ){
	w = _w;
	h = _h;
	val = new NUM*[h];
	for(int i=0; i<h; i++ )
		val[i] = new NUM[w];
}

Matrix::Matrix( const Matrix& m ){
	w = m.w;
	h = m.h;
	val = new NUM*[h];

	int i;
	for(i=0; i<h; i++ )
		val[i] = new NUM[w];

	for(i=0; i<h; i++)
		memcpy( val[i], m.val[i], w*sizeof(NUM) );
}


Matrix::~Matrix(){
	for(int i=0; i<h; i++)
		delete [] val[i];
	delete [] val;
}


NUM* Matrix::operator [] (int ndx){
	return val[ndx];
}

Vector Matrix::operator *( Vector& v){
	Vector res(h);
	//su kompatibilne?
	if( w!=v.size)
		return Vector(0);
	
	for(int i=0; i<h; i++ ){
		res.val[i] = 0;
		for(int j=0; j<w; j++)
			res.val[i] += val[i][j]*(v.val[j]);
	}

	return res;
}


Matrix Matrix::operator * (Matrix& m){
	//su matice kompatibilne?
	if( w!=m.h )
		return Matrix(0,0);

	Matrix res (h,m.w);
	for(int i=0; i<h; i++)
		for(int j=0; j<m.w; j++){
			NUM temp = 0;
			for(int k=0; k<w; k++)
				temp += val[i][k]*m.val[k][j];
			res[i][j] = temp;
		}

	return res;
}


void Matrix::print(){
	for(int i=0; i<h; i++ ){
		for(int j=0; j<w; j++ )
			cout<<val[i][j]<<"\t";
		cout<<endl;
	}
}

void Matrix::printClean(){
	for(int i=0; i<h; i++ ){
		for(int j=0; j<w; j++ ){
			if( fabs(val[i][j])<1e-9 )
				cout<<0<<"\t";
			else
				cout<<val[i][j]<<"\t";
		}
		cout<<endl;
	}
}


void Matrix::setIdent(){
	//vynuluj vsetko
	for( int i=0; i<h; i++ )
		memset( val[i], 0, w*sizeof(NUM) );
	//nastav 1 tam, kde treba
	int j=0;
	while((j<w)&&(j<h)){
		val[j][j] = 1;
		j++;
	}
}


bool Matrix::isIdent(){
	for( int i=0; i<h; i++ )
		for( int j=0; j<w; j++ )
			if( i==j ){
				//ocakavame 1
				if( !isZero2(val[i][j]-1) )
					return false;
			} else {
				//ocakavame 0
				if( !isZero2(val[i][j]) )
					return false;
			}
	return true;
}

void Matrix::rowDiv( int ndx, NUM coef ){
	for(int i=0; i<w; i++)
		val[ndx][i] = val[ndx][i]/coef;
}

void Matrix::rowAdd( int destNdx, int srcNdx, NUM coef ){
	for(int i=0; i<w; i++)
		val[destNdx][i] += coef * val[srcNdx][i];
}


void Matrix::colDiv( int ndx, NUM coef ){
	for(int i=0; i<h; i++)
		val[i][ndx] = val[i][ndx]/coef;
}

void Matrix::colAdd( int destNdx, int srcNdx, NUM coef ){
	for(int i=0; i<h; i++)
		val[i][destNdx] += coef * val[i][srcNdx];
}


Matrix Matrix::operator !(){
	Matrix scratchCopy(*this);
	return scratchCopy.invert();
}

void Matrix::operator = (const Matrix& m){

	int i;

	for(i=0; i<h; i++)
		delete [] val[i];
	delete [] val;


	w = m.w;
	h = m.h;
	val = new NUM*[h];

	for(i=0; i<h; i++ )
		val[i] = new NUM[w];

	for(i=0; i<h; i++)
		memcpy( val[i], m.val[i], w*sizeof(NUM) );
}


Matrix Matrix::invert(){
	int grad = h;
	if(grad>w) grad = w;

	for(int i=0; i<grad; i++){
		//mame veduci prvok [i][i]?
		if(isZero(val[i][i])){
			//ak nie, hladaj nenulovy prvok v stlpci i
			for(int j=i+1; j<h; j++){
				if(!isZero(val[j][i])){
					journal.push_back( makeJItem( OP_ADD, i, 1, j ) );
					rowAdd( i, j, 1 );
					break;
				}
			}
		}
		//ak je tu val[i][i] este stale nulova,
		//v takom pripade matica jednotkova nebude...
		//cize si toto kolo odsedime
		if(!isZero(val[i][i])){

			//normalizuj i-ty riadok veducim prvkom
			if(val[i][i]!=1){
				journal.push_back( makeJItem(OP_DIV, i, val[i][i]) );
				rowDiv( i, val[i][i] );
			}
			//vynuluj ostatne
			for(int j=0; (j<h); j++){
				if((i!=j) && (!isZero(val[j][i]))){
					journal.push_back( makeJItem(OP_ADD, j, -val[j][i], i) );
					rowAdd( j, i, -val[j][i] );
				}
			}

		}
	}

	//zamen vysku<->sirku pre transponovanu maticu
	Matrix res( w, h );
	//nastav maticu MxN na jednotkovu
	res.setIdent();
	//spracuj zurnal
	jItem item;
	while(!journal.empty()){
		item = journal.back();
		int minsize = ( w < h ) ? w : h;
		int maxop = ( item.destNdx > item.srcNdx ) ? item.destNdx : item.srcNdx;
		if( minsize>maxop ){

			switch(item.op){
			case OP_ADD:
				res.colAdd( item.srcNdx, item.destNdx, item.coef );
				break;
			case OP_DIV:
				res.colDiv( item.destNdx, item.coef );
				break;
			}
		}
		journal.pop_back();
	}
	return res;
}
