//pocet slov vstupnej sady
#define WORDCOUNT (29*3)
//pocet pismenok v slove
#define WORDSIZE 6
//pocet slabik v slove
#define WORDSEG 3
//pocet A_B ramcov
#define FRAMECOUNT 3

//vstupna sada
char* arrWords[WORDCOUNT] = {
	"babete","gubedo","pibera",
	"babite","gubido","pibira",
	"babote","gubodo","pibora",
	"babute","gubudo","pibura",
	"babyte","gubydo","pibyra",
	"batate","gutado","pitara",
	"batite","gutido","pitira",
	"batote","gutodo","pitora",
	"batute","gutudo","pitura",
	"batyte","gutydo","pityra",
	"bagate","gugado","pigara",
	"bagete","gugedo","pigera",
	"bagite","gugido","pigira",
	"bagote","gugodo","pigora",
	"bagyte","gugydo","pigyra",
	"badate","gudado","pidara",
	"badete","gudedo","pidera",
	"badite","gudido","pidira",
	"badyte","gudydo","pidyra",
	"bapate","gupado","pipara",
	"bapete","gupedo","pipera",
	"bapote","gupodo","pipora",
	"bapute","gupudo","pipura",
	"bapyte","gupydo","pipyra",
	"barete","guredo","pirera",
	"barite","gurido","pirira",
	"barote","gurodo","pirora",
	"barute","gurudo","pirura",
	"baryte","gurydo","piryra"
};

//pocet slabik vstupnej sady
#define L_ARRSYL 35
#define dimInput L_ARRSYL
#define dimOutput L_ARRSYL

//slabiky vstupnej sady
char* arrSyl[L_ARRSYL] = { "ba", "te", "gu", "do", "pi", "ra",
						   "be","bi","bo","bu","by",
						   "ta","ti","to","tu","ty",
						   "ga","ge","gi","go","gy",
						   "da","de","di","dy",
						   "pa","pe","po","pu","py",
						   "re","ri","ro","ru","ry",
};

//vrati index slabiky
int getOneHotNdxInternal( char c0, char c1 ){
	int i;
	for( i=0; i<L_ARRSYL; i++ )
		if((arrSyl[i][0]==c0)&&(arrSyl[i][1]==c1)) return i;
	return -1;
}

//vrati index slabiky
int getOneHotNdx( char *c ){
	return getOneHotNdxInternal( c[0], c[1] );
}

//vyrobi vektor zodpovedajuci danej slabike
Vector getSyllabe(char* c){
	int ix =  getOneHotNdx(c);
	Vector res(L_ARRSYL);
	int i;
	for( i=0; i<L_ARRSYL; i++ )
		res.val[i] = (ix==i) ? 1 : 0;
	return res;
}

//posun vo vstupnej postupnosti od pozicie s na poziciu o t taktov neskor
#define SEEK(s,t) s+(2*(t))

//nastavi na 0 vsetky hodnoty vo vektore okrem najvyssej, tu nastavi na 1
Vector applyOneHotFilter( Vector o ){
	int maxNdx = 0;
	int i;
	for( i=0; i<o.size; i++ )
		if(o.val[maxNdx]<o.val[i])
			maxNdx = i;
	for( i=0; i<o.size; i++ )
		o.val[i] = (i!=maxNdx) ? 0 : 1;
	return o;
}

//vyrobi PW skombinovanim slov s danymi indexami
void makePartword( char* buffer, int n1, int n2 ){
	buffer[WORDSIZE] = 0;
	if(rand()%2==0){
		buffer[0] = arrWords[n1][4];
		buffer[1] = arrWords[n1][5];
		buffer[2] = arrWords[n2][0];
		buffer[3] = arrWords[n2][1];
		buffer[4] = arrWords[n2][2];
		buffer[5] = arrWords[n2][3];
	} else {
		buffer[0] = arrWords[n1][2];
		buffer[1] = arrWords[n1][3];
		buffer[2] = arrWords[n1][4];
		buffer[3] = arrWords[n1][5];
		buffer[4] = arrWords[n2][0];
		buffer[5] = arrWords[n2][1];
	}
}

//vyrobi RW skombinovanim slov s danymi indexami
void makeRuleword( char* buffer, int n1, int n2 ){
	buffer[WORDSIZE] = 0;
	if(rand()%2==0){
		buffer[0] = arrWords[n1][0];
		buffer[1] = arrWords[n1][1];
		buffer[2] = arrWords[n2][0];
		buffer[3] = arrWords[n2][1];
		buffer[4] = arrWords[n1][4];
		buffer[5] = arrWords[n1][5];
	} else {
		buffer[0] = arrWords[n1][0];
		buffer[1] = arrWords[n1][1];
		buffer[2] = arrWords[n2][4];
		buffer[3] = arrWords[n2][5];
		buffer[4] = arrWords[n1][4];
		buffer[5] = arrWords[n1][5];
	}
}

