/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.View;
import org.jgroups.protocols.PingRsp;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class MERGE2
extends Protocol {
    Address local_addr = null;
    String group_name = null;
    private FindSubgroups task = null;
    private final Object task_lock = new Object();
    long min_interval = 5000L;
    long max_interval = 20000L;
    boolean is_coord = false;
    final Promise find_promise = new Promise();
    boolean use_separate_thread = false;

    public String getName() {
        return "MERGE2";
    }

    public long getMinInterval() {
        return this.min_interval;
    }

    public void setMinInterval(long i) {
        this.min_interval = i;
    }

    public long getMaxInterval() {
        return this.max_interval;
    }

    public void setMaxInterval(long l) {
        this.max_interval = l;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("min_interval");
        if (str != null) {
            this.min_interval = Long.parseLong(str);
            props.remove("min_interval");
        }
        if ((str = props.getProperty("max_interval")) != null) {
            this.max_interval = Long.parseLong(str);
            props.remove("max_interval");
        }
        if (this.min_interval <= 0L || this.max_interval <= 0L) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"min_interval and max_interval have to be > 0");
            }
            return false;
        }
        if (this.max_interval <= this.min_interval) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"max_interval has to be greater than min_interval");
            }
            return false;
        }
        str = props.getProperty("use_separate_thread");
        if (str != null) {
            this.use_separate_thread = Boolean.valueOf(str);
            props.remove("use_separate_thread");
        }
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>(1);
        retval.addElement(new Integer(12));
        return retval;
    }

    public void stop() {
        this.is_coord = false;
        this.stopTask();
    }

    public void startUpHandler() {
    }

    public void startDownHandler() {
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.passUp(evt);
                break;
            }
            case 13: {
                this.find_promise.setResult(evt.getArg());
                this.passUp(evt);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 2: {
                this.group_name = (String)evt.getArg();
                this.passDown(evt);
                break;
            }
            case 4: {
                this.group_name = null;
                this.passDown(evt);
                break;
            }
            case 6: {
                this.passDown(evt);
                Vector mbrs = ((View)evt.getArg()).getMembers();
                if (mbrs == null || mbrs.size() == 0 || this.local_addr == null) {
                    this.stopTask();
                    break;
                }
                Address coord = (Address)mbrs.elementAt(0);
                if (coord.equals(this.local_addr)) {
                    this.is_coord = true;
                    this.startTask();
                    break;
                }
                if (this.is_coord) {
                    this.is_coord = false;
                }
                this.stopTask();
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTask() {
        Object object = this.task_lock;
        synchronized (object) {
            if (this.task == null) {
                this.task = new FindSubgroups();
            }
            this.task.start();
            if (this.group_name != null) {
                String prefix = " (channel=";
                String tmp = this.task.getName();
                if (tmp != null && tmp.indexOf(prefix) == -1) {
                    tmp = tmp + prefix + this.group_name + ")";
                    this.task.setName(tmp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTask() {
        Object object = this.task_lock;
        synchronized (object) {
            if (this.task != null) {
                this.task.stop();
                this.task = null;
            }
        }
    }

    private class FindSubgroups
    implements Runnable {
        Thread thread = null;

        private FindSubgroups() {
        }

        String getName() {
            return this.thread != null ? this.thread.getName() : null;
        }

        void setName(String thread_name) {
            if (this.thread != null) {
                this.thread.setName(thread_name);
            }
        }

        public void start() {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread(Util.getGlobalThreadGroup(), this, "MERGE2.FindSubgroups thread");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }

        public void stop() {
            if (this.thread != null) {
                Thread tmp = this.thread;
                this.thread = null;
                tmp.interrupt();
                MERGE2.this.find_promise.reset();
            }
            this.thread = null;
        }

        public void run() {
            while (this.thread != null && Thread.currentThread().equals(this.thread)) {
                Vector coords;
                long interval = this.computeInterval();
                Util.sleep(interval);
                if (this.thread == null) break;
                Vector initial_mbrs = this.findInitialMembers();
                if (this.thread == null) break;
                if (MERGE2.this.log.isDebugEnabled()) {
                    MERGE2.this.log.debug((Object)("initial_mbrs=" + initial_mbrs));
                }
                if ((coords = this.detectMultipleCoordinators(initial_mbrs)) == null || coords.size() <= 1) continue;
                if (MERGE2.this.log.isDebugEnabled()) {
                    MERGE2.this.log.debug((Object)("found multiple coordinators: " + coords + "; sending up MERGE event"));
                }
                final Event evt = new Event(14, coords);
                if (MERGE2.this.use_separate_thread) {
                    Thread merge_notifier = new Thread(){

                        public void run() {
                            MERGE2.this.passUp(evt);
                        }
                    };
                    merge_notifier.setDaemon(true);
                    merge_notifier.setName("merge notifier thread");
                    merge_notifier.start();
                    continue;
                }
                MERGE2.this.passUp(evt);
            }
            if (MERGE2.this.trace) {
                MERGE2.this.log.trace((Object)("MERGE2.FindSubgroups thread terminated (local_addr=" + MERGE2.this.local_addr + ")"));
            }
        }

        long computeInterval() {
            return MERGE2.this.min_interval + Util.random(MERGE2.this.max_interval - MERGE2.this.min_interval);
        }

        Vector findInitialMembers() {
            PingRsp tmp = new PingRsp(MERGE2.this.local_addr, MERGE2.this.local_addr, true);
            MERGE2.this.find_promise.reset();
            MERGE2.this.passDown(Event.FIND_INITIAL_MBRS_EVT);
            Vector retval = (Vector)MERGE2.this.find_promise.getResult(0L);
            if (retval != null && MERGE2.this.is_coord && MERGE2.this.local_addr != null && !retval.contains(tmp)) {
                retval.add(tmp);
            }
            return retval;
        }

        Vector detectMultipleCoordinators(Vector initial_mbrs) {
            Vector<Address> ret = new Vector<Address>(11);
            if (initial_mbrs == null) {
                return null;
            }
            for (int i = 0; i < initial_mbrs.size(); ++i) {
                Address coord;
                PingRsp rsp = (PingRsp)initial_mbrs.elementAt(i);
                if (!rsp.is_server || ret.contains(coord = rsp.getCoordAddress())) continue;
                ret.addElement(coord);
            }
            return ret;
        }
    }
}

