/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import javax.management.MBeanServer;
import org.jgroups.Channel;
import org.jgroups.JChannelFactory;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Util;

public class JChannelFactoryDemo {
    JChannelFactory factory;
    MBeanServer server;

    public static void main(String[] args) throws Exception {
        new JChannelFactoryDemo().start();
    }

    private void start() throws Exception {
        this.server = Util.getMBeanServer();
        if (this.server == null) {
            throw new Exception("No MBeanServer found; JChannelFactory needs to be run with an MBeanServer present, inside JDK 5, or with ExposeChannel set to false");
        }
        this.factory = new JChannelFactory();
        this.factory.setExposeChannels(true);
        this.factory.setExposeProtocols(true);
        this.factory.setDomain("jgroups.mux");
        this.factory.setMultiplexerConfig("stacks.xml");
        this.factory.create();
        Channel ch = this.factory.createMultiplexerChannel("udp", "bla");
        JmxConfigurator.registerChannelFactory(this.factory, this.server, "jgroups.mux:name=Multiplexer");
        while (true) {
            Util.sleep(5000L);
        }
    }
}

