/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.ChannelException;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class LargeStateTransferTest
extends TestCase {
    JChannel provider;
    JChannel requester;
    Promise p = new Promise();
    String props = "udp.xml";
    long start;
    long stop;
    static final int SIZE_1 = 100000;
    static final int SIZE_2 = 1000000;
    static final int SIZE_3 = 5000000;
    static final int SIZE_4 = 10000000;

    public LargeStateTransferTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.props = System.getProperty("props", this.props);
        LargeStateTransferTest.log("Using configuration file " + this.props);
        this.provider = new JChannel(this.props);
        this.requester = new JChannel(this.props);
    }

    protected void tearDown() throws Exception {
        if (this.provider != null) {
            this.provider.close();
        }
        if (this.requester != null) {
            this.requester.close();
        }
        super.tearDown();
    }

    public void testStateTransfer1() throws ChannelException {
        this._testStateTransfer(100000);
    }

    public void testStateTransfer2() throws ChannelException {
        this._testStateTransfer(1000000);
    }

    public void testStateTransfer3() throws ChannelException {
        this._testStateTransfer(5000000);
    }

    public void testStateTransfer4() throws ChannelException {
        this._testStateTransfer(10000000);
    }

    public void _testStateTransfer(int size) throws ChannelException {
        this.provider.setReceiver(new Provider(size));
        this.provider.connect("X");
        this.p.reset();
        this.requester.setReceiver(new Requester(this.p));
        this.requester.connect("X");
        LargeStateTransferTest.log("requesting state of " + size + " bytes");
        this.start = System.currentTimeMillis();
        this.requester.getState(null, 20000L);
        Object result = this.p.getResult(10000L);
        this.stop = System.currentTimeMillis();
        LargeStateTransferTest.log("result=" + result + " bytes (in " + (this.stop - this.start) + "ms)");
        LargeStateTransferTest.assertNotNull((Object)result);
        LargeStateTransferTest.assertEquals((Object)result, (Object)new Integer(size));
    }

    static void log(String msg) {
        System.out.println(Thread.currentThread() + " -- " + msg);
    }

    public static Test suite() {
        return new TestSuite(LargeStateTransferTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LargeStateTransferTest.suite());
    }

    private static class Requester
    extends ExtendedReceiverAdapter {
        Promise p;

        public Requester(Promise p) {
            this.p = p;
        }

        public byte[] getState() {
            throw new UnsupportedOperationException("not implemented by requester");
        }

        public void setState(byte[] state) {
            this.p.setResult(new Integer(state.length));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void setState(InputStream istream) {
            ObjectInputStream ois = null;
            int size = 0;
            try {
                ois = new ObjectInputStream(istream);
                size = ois.readInt();
                byte[] stateReceived = new byte[size];
                ois.read(stateReceived);
            }
            catch (IOException e) {
                Util.close(ois);
                catch (Throwable throwable) {
                    Util.close(ois);
                    throw throwable;
                }
            }
            Util.close(ois);
            this.p.setResult(new Integer(size));
        }
    }

    private static class Provider
    extends ExtendedReceiverAdapter {
        byte[] state;

        public Provider(int size) {
            this.state = new byte[size];
        }

        public byte[] getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(OutputStream ostream) {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(ostream);
                oos.writeInt(this.state.length);
                oos.write(this.state);
            }
            catch (IOException iOException) {
            }
            finally {
                Util.close(ostream);
            }
        }

        public void setState(byte[] state) {
            throw new UnsupportedOperationException("not implemented by provider");
        }
    }
}

