/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.UNICAST;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;

public class UNICAST_Test
extends TestCase {
    IpAddress a1;
    IpAddress a2;
    Vector members;
    View v;
    Simulator s;
    final int SIZE = 1000;
    final int NUM_MSGS = 10000;

    public UNICAST_Test(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.s.stop();
    }

    public void testReceptionOfAllMessages() throws Throwable {
        UNICAST unicast = new UNICAST();
        Properties props = new Properties();
        props.setProperty("timeout", "500,1000,2000,3000");
        unicast.setProperties(props);
        Protocol[] stack = new Protocol[]{unicast};
        this.createStack(stack);
        this._testReceptionOfAllMessages();
    }

    public void testReceptionOfAllMessagesWithDISCARD() throws Throwable {
        UNICAST unicast = new UNICAST();
        Properties props = new Properties();
        props.setProperty("timeout", "500,1000,2000,3000");
        unicast.setProperties(props);
        DISCARD discard = new DISCARD();
        props.clear();
        props.setProperty("down", "0.1");
        discard.setProperties(props);
        Protocol[] stack = new Protocol[]{unicast, discard};
        this.createStack(stack);
        this._testReceptionOfAllMessages();
    }

    private static byte[] createPayload(int size, int seqno) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.putInt(seqno);
        return buf.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testReceptionOfAllMessages() throws Throwable {
        int num_received = 0;
        Receiver r = new Receiver();
        this.s.setReceiver(r);
        for (int i = 1; i <= 10000; ++i) {
            Message msg = new Message((Address)this.a1, null, UNICAST_Test.createPayload(1000, i));
            Event evt = new Event(1, msg);
            this.s.send(evt);
            if (i % 1000 != 0) continue;
            System.out.println("==> " + i);
        }
        for (int num_tries = 10; (num_received = r.getNumberOfReceivedMessages()) != 10000 && num_tries > 0; --num_tries) {
            if (r.getException() != null) {
                throw r.getException();
            }
            Receiver receiver = r;
            synchronized (receiver) {
                try {
                    r.wait(3000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                continue;
            }
        }
        this.printStats(num_received);
        UNICAST_Test.assertTrue((num_received == 10000 ? 1 : 0) != 0);
    }

    private void createStack(Protocol[] stack) throws Exception {
        this.a1 = new IpAddress(1111);
        this.members = new Vector();
        this.members.add(this.a1);
        this.v = new View(this.a1, 1L, this.members);
        this.s = new Simulator();
        this.s.setLocalAddress(this.a1);
        this.s.setView(this.v);
        this.s.addMember(this.a1);
        this.s.setProtocolStack(stack);
        this.s.start();
    }

    private void printStats(int num_received) {
        System.out.println("-- num received=" + num_received + ", stats:\n" + this.s.dumpStats());
    }

    public static Test suite() {
        TestSuite s = new TestSuite(UNICAST_Test.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)UNICAST_Test.suite());
    }

    class Receiver
    implements Simulator.Receiver {
        int num_mgs_received = 0;
        int next = 1;
        Throwable exception = null;
        boolean received_all = false;

        Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Event evt) {
            if (evt.getType() == 1) {
                if (this.exception != null) {
                    return;
                }
                Message msg = (Message)evt.getArg();
                ByteBuffer buf = ByteBuffer.wrap(msg.getRawBuffer());
                int seqno = buf.getInt();
                if (seqno != this.next) {
                    this.exception = new Exception("expected seqno was " + this.next + ", but received " + seqno);
                    return;
                }
                ++this.next;
                ++this.num_mgs_received;
                if (this.num_mgs_received % 1000 == 0) {
                    System.out.println("<== " + this.num_mgs_received);
                }
                if (this.num_mgs_received == 10000) {
                    Receiver receiver = this;
                    synchronized (receiver) {
                        this.received_all = true;
                        this.notifyAll();
                    }
                }
            }
        }

        public int getNumberOfReceivedMessages() {
            return this.num_mgs_received;
        }

        public boolean receivedAll() {
            return this.received_all;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

