/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.util.Util;

public class TimeScheduler {
    private static final long SUSPEND_INTERVAL = 30000L;
    private static final long MAX_EXECUTION_TIME = 5000L;
    private static final int RUN = 0;
    private static final int SUSPEND = 1;
    private static final int STOPPING = 2;
    private static final int STOP = 3;
    private static final String THREAD_NAME = "TimeScheduler.Thread";
    private Thread thread = null;
    private int thread_state = 1;
    private long suspend_interval = 30000L;
    private final TaskQueue queue = new TaskQueue();
    protected static final Log log = LogFactory.getLog((Class)TimeScheduler.class);

    private void _start() {
        this.thread_state = 0;
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(Util.getGlobalThreadGroup(), new Loop(), THREAD_NAME);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    private void _unsuspend() {
        this.thread_state = 0;
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(Util.getGlobalThreadGroup(), new Loop(), THREAD_NAME);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    private void _suspend() {
        this.thread_state = 1;
        this.thread = null;
    }

    private void _stopping() {
        this.thread_state = 2;
    }

    private void _stop() {
        this.thread_state = 3;
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _run() {
        while (true) {
            Task task;
            Object object = this;
            synchronized (object) {
                if (this.thread == null || this.thread.isInterrupted()) {
                    return;
                }
            }
            object = this.queue;
            synchronized (object) {
                long waitTime;
                IntTask intTask;
                if (this.queue.isEmpty()) {
                    try {
                        this.queue.wait(this.suspend_interval);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                    if (this.queue.isEmpty()) {
                        this._suspend();
                        return;
                    }
                }
                IntTask ex = intTask = this.queue.getFirst();
                synchronized (ex) {
                    task = intTask.task;
                    if (task.cancelled()) {
                        this.queue.removeFirst();
                        continue;
                    }
                    long execTime = intTask.sched;
                    long currTime = System.currentTimeMillis();
                    waitTime = execTime - currTime;
                    if (waitTime <= 0L) {
                        long intervalTime = task.nextInterval();
                        long schedTime = intTask.relative ? currTime + intervalTime : execTime + intervalTime;
                        this.queue.rescheduleFirst(schedTime);
                    }
                }
                if (waitTime > 0L) {
                    try {
                        this.queue.wait(waitTime);
                    }
                    catch (InterruptedException ex2) {
                        return;
                    }
                }
            }
            long start = System.currentTimeMillis();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Running task " + task));
                }
                task.run();
                long stop = System.currentTimeMillis();
                long diff = stop - start;
                if (diff < 5000L || !log.isWarnEnabled()) continue;
                log.warn((Object)("task " + task + " took " + diff + "ms to execute, " + "please check why it is taking so long. It is delaying other tasks"));
                continue;
            }
            catch (Throwable ex) {
                log.error((Object)("failed running task " + task), ex);
                continue;
            }
            break;
        }
    }

    public TimeScheduler(long suspend_interval) {
        this.suspend_interval = suspend_interval;
    }

    public TimeScheduler() {
        this(30000L);
    }

    public void setSuspendInterval(long s) {
        this.suspend_interval = s;
    }

    public long getSuspendInterval() {
        return this.suspend_interval;
    }

    public String dumpTaskQueue() {
        return this.queue != null ? this.queue.toString() : "<empty>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Task t, boolean relative) {
        long interval = t.nextInterval();
        if (interval < 0L) {
            return;
        }
        long sched = System.currentTimeMillis() + interval;
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.queue.add(new IntTask(t, sched, relative));
            switch (this.thread_state) {
                case 0: {
                    this.queue.notifyAll();
                    break;
                }
                case 1: {
                    this._unsuspend();
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    public void add(Task t) {
        this.add(t, true);
    }

    public int size() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            switch (this.thread_state) {
                case 0: {
                    break;
                }
                case 1: {
                    this._unsuspend();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this._start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            switch (this.thread_state) {
                case 0: {
                    this._stopping();
                    break;
                }
                case 1: {
                    this._stop();
                    return;
                }
                case 2: {
                    return;
                }
                case 3: {
                    return;
                }
            }
            this.thread.interrupt();
        }
        this.thread.join();
        taskQueue = this.queue;
        synchronized (taskQueue) {
            this.queue.clear();
            this._stop();
        }
    }

    private static class TaskQueue {
        private final SortedSet set = new TreeSet();

        public void add(IntTask t) {
            this.set.add(t);
        }

        public void remove(IntTask t) {
            this.set.remove(t);
        }

        public IntTask getFirst() {
            return (IntTask)this.set.first();
        }

        public void removeFirst() {
            Iterator it = this.set.iterator();
            it.next();
            it.remove();
        }

        public void rescheduleFirst(long sched) {
            Iterator it = this.set.iterator();
            IntTask t = (IntTask)it.next();
            it.remove();
            t.sched = sched;
            this.set.add(t);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public void clear() {
            this.set.clear();
        }

        public int size() {
            return this.set.size();
        }

        public String toString() {
            return this.set.toString();
        }
    }

    private class Loop
    implements Runnable {
        private Loop() {
        }

        public void run() {
            try {
                TimeScheduler.this._run();
            }
            catch (Throwable t) {
                log.error((Object)"exception in loop", t);
            }
        }
    }

    private static class IntTask
    implements Comparable {
        public final Task task;
        public long sched;
        public final boolean relative;

        public IntTask(Task task, long sched, boolean relative) {
            this.task = task;
            this.sched = sched;
            this.relative = relative;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof IntTask)) {
                return -1;
            }
            IntTask other = (IntTask)obj;
            if (this.sched < other.sched) {
                return -1;
            }
            if (this.sched > other.sched) {
                return 1;
            }
            return this.task.hashCode() - other.task.hashCode();
        }

        public String toString() {
            if (this.task == null) {
                return "<unnamed>";
            }
            return this.task.getClass().getName();
        }
    }

    public static interface CancellableTask
    extends Task {
        public void cancel();
    }

    public static interface Task {
        public boolean cancelled();

        public long nextInterval();

        public void run();
    }
}

