/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class ReentrantLock
implements Sync {
    protected Thread owner_ = null;
    protected long holds_ = 0L;

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (caller == this.owner_) {
                ++this.holds_;
            } else {
                try {
                    while (this.owner_ != null) {
                        this.wait();
                    }
                    this.owner_ = caller;
                    this.holds_ = 1L;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (caller == this.owner_) {
                ++this.holds_;
                boolean bl = true;
                return bl;
            }
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1L;
                boolean bl = true;
                return bl;
            }
            if (msecs <= 0L) {
                boolean bl = false;
                return bl;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            try {
                do {
                    this.wait(waitTime);
                    if (caller == this.owner_) {
                        ++this.holds_;
                        boolean bl = true;
                        return bl;
                    }
                    if (this.owner_ != null) continue;
                    this.owner_ = caller;
                    this.holds_ = 1L;
                    boolean bl = true;
                    return bl;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        if (Thread.currentThread() != this.owner_) {
            throw new Error("Illegal Lock usage");
        }
        if (--this.holds_ == 0L) {
            this.owner_ = null;
            this.notify();
        }
    }

    public synchronized void release(long n) {
        if (Thread.currentThread() != this.owner_ || n > this.holds_) {
            throw new Error("Illegal Lock usage");
        }
        this.holds_ -= n;
        if (this.holds_ == 0L) {
            this.owner_ = null;
            this.notify();
        }
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.owner_) {
            return 0L;
        }
        return this.holds_;
    }
}

