/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class AngleChooser
extends JPanel
implements MouseListener,
MouseMotionListener {
    static final long serialVersionUID = 40L;
    public final int xSize = 50;
    public final int ySize = 50;
    private Tool tool;
    public double angle = 0.0;
    public int angleDeg = 0;

    public AngleChooser(Tool t) {
        this();
        this.tool = t;
    }

    public AngleChooser(Tool t, double a) {
        this();
        this.tool = t;
        this.angle = a;
    }

    public AngleChooser() {
        this.setSize(50, 50);
        this.setPreferredSize(new Dimension(50, 50));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics g1) {
        super.paint(g1);
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.BLACK);
        g.drawArc(0, 0, 49, 49, 0, 360);
        g.drawLine(24, 24, Math.round(24.0f + (float)(Math.cos(this.angle) * 24.0)), 24 + Math.round((float)(Math.sin(this.angle) * 24.0)));
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX() - 25;
        int y = e.getY() - 25;
        this.angle = y >= 0 ? Math.acos((double)x / Math.sqrt(x * x + y * y)) : Math.acos(-((double)x) / Math.sqrt(x * x + y * y)) + Math.PI;
        this.angleDeg = (int)Math.round(this.angle * 180.0 / Math.PI);
        this.repaint();
        if (this.tool != null) {
            this.tool.angle = this.angle;
        }
    }

    public double getAngle() {
        return this.angle;
    }

    public int getAngleDeg() {
        return this.angleDeg;
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX() - 25;
        int y = e.getY() - 25;
        this.angle = y >= 0 ? Math.acos((double)x / Math.sqrt(x * x + y * y)) : Math.acos(-((double)x) / Math.sqrt(x * x + y * y)) + Math.PI;
        this.angleDeg = (int)Math.round(this.angle * 180.0 / Math.PI);
        if (this.tool != null) {
            this.tool.angle = this.angle;
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

