/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Eraser
extends Tool {
    public final boolean drawable = true;
    private static final long serialVersionUID = 20L;
    public float width = 9.0f;
    public int alpha = 255;

    public Eraser() {
        this.points = new Vector();
        this.colors = new Vector();
        this.colors.add(Color.blue);
        this.colors.add(Color.blue);
    }

    public Eraser(Color c) {
        this.points = new Vector();
        this.colors = new Vector();
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.add(cc);
        this.colors.add(Color.blue);
    }

    public void draw(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke thindashed = new BasicStroke(this.width, 0, 2, 1.0f);
        g.setStroke(thindashed);
        g.setColor((Color)this.colors.get(1));
        GeneralPath gp = new GeneralPath();
        int i = 0;
        while (i < this.points.size() - 1) {
            gp.append(new Line2D.Float((Point)this.points.get(i), (Point)this.points.get(i + 1)), true);
            ++i;
        }
        g.draw(gp);
    }

    public void setColor(Color c) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.set(0, cc);
    }

    public void drawPreview(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        BasicStroke thindashed = new BasicStroke(this.width, 0, 2, 1.0f);
        g.setStroke(thindashed);
        g.setColor(Color.GRAY);
        GeneralPath gp = new GeneralPath();
        int i = 0;
        while (i < this.points.size() - 1) {
            gp.append(new Line2D.Float((Point)this.points.get(i), (Point)this.points.get(i + 1)), true);
            ++i;
        }
        g.draw(gp);
    }

    public JPanel settingPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Line width"));
        JSlider widthSlider = new JSlider(0, 50, 300, Math.round(this.width * 10.0f));
        widthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Eraser.this.width = (float)((JSlider)e.getSource()).getValue() / 10.0f;
            }
        });
        widthSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(widthSlider);
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public boolean isDrawable() {
        return true;
    }
}

