/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FeltTipPen
extends Tool {
    public final boolean drawable = true;
    private static final long serialVersionUID = 12L;
    public float width = 2.0f;
    public int alpha = 255;
    private long startTime;
    private long lastTime;
    private int lastX;
    private int lastY;
    final int xSize = 1024;
    final int ySize = 768;

    public FeltTipPen() {
        this.points = new Vector();
        this.colors = new Vector();
        this.time = new Vector();
        this.data = new Vector();
        this.colors.add(Color.blue);
        this.colors.add(Color.blue);
    }

    public FeltTipPen(Color c) {
        this.points = new Vector();
        this.colors = new Vector();
        this.time = new Vector();
        this.data = new Vector();
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.add(cc);
        this.colors.add(Color.blue);
    }

    public void draw(Graphics g1) {
        Graphics2D g2 = (Graphics2D)g1;
        BufferedImage buf = new BufferedImage(1024, 768, 2);
        Graphics2D g = (Graphics2D)buf.getGraphics();
        Color cc = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        int i = 0;
        while (i < 1024) {
            int j = 0;
            while (j < 768) {
                buf.setRGB(i, j, cc.getRGB());
                ++j;
            }
            ++i;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke thindashed = new BasicStroke(this.width, 0, 2, 1.0f);
        g.setStroke(thindashed);
        Color des = (Color)this.colors.get(0);
        Color col = new Color(des.getRed(), des.getGreen(), des.getBlue(), 255);
        float alf = des.getAlpha();
        g.setColor(col);
        this.computeSpeeds();
        int i2 = 0;
        while (i2 < this.points.size() - 1) {
            thindashed = new BasicStroke(this.lineWidthBySpeed((Double)this.data.get(i2 + 1)), 1, 2, 1.0f);
            g.setStroke(thindashed);
            g.drawLine(((Point)this.points.get((int)i2)).x, ((Point)this.points.get((int)i2)).y, ((Point)this.points.get((int)(i2 + 1))).x, ((Point)this.points.get((int)(i2 + 1))).y);
            ++i2;
        }
        i2 = 0;
        while (i2 < 1024) {
            int j = 0;
            while (j < 768) {
                if (buf.getRGB(i2, j) != 0) {
                    Color a = new Color(buf.getRGB(i2, j), true);
                    Color b = new Color(a.getRed(), a.getGreen(), a.getBlue(), Math.round((float)a.getAlpha() * alf / 255.0f));
                    buf.setRGB(i2, j, b.getRGB());
                }
                ++j;
            }
            ++i2;
        }
        g2.drawImage((Image)buf, 0, 0, null);
    }

    public float lineWidthBySpeed(double speed) {
        float result = (float)((double)this.width * (1.0 + 1.0 / (speed / 200.0 + 1.0)));
        return result;
    }

    public void setColor(Color c) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.set(0, cc);
    }

    public void drawPreview(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setColor(Color.GRAY);
        int i = 0;
        while (i < this.points.size() - 1) {
            g.drawLine(((Point)this.points.get((int)i)).x, ((Point)this.points.get((int)i)).y, ((Point)this.points.get((int)(i + 1))).x, ((Point)this.points.get((int)(i + 1))).y);
            ++i;
        }
    }

    public JPanel settingPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Set width"));
        JSlider widthSlider = new JSlider(0, 0, 100, Math.round(this.width * 10.0f));
        widthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FeltTipPen.this.width = (float)((JSlider)e.getSource()).getValue() / 10.0f;
            }
        });
        widthSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(widthSlider);
        panel.add(new JLabel("Opacity"));
        JSlider alphaSlider = new JSlider(0, 0, 255, 255);
        alphaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FeltTipPen.this.alpha = ((JSlider)e.getSource()).getValue();
                FeltTipPen.this.setColor((Color)FeltTipPen.this.colors.get(0));
            }
        });
        alphaSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(alphaSlider);
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public boolean isDrawable() {
        return true;
    }

    public void computeSpeeds() {
        this.data.clear();
        this.data.add(0.0);
        int i = 1;
        while (i < this.time.size()) {
            double distance = Math.sqrt(Math.pow(((Point)this.points.get(i - 1)).getX() - ((Point)this.points.get(i)).getX(), 2.0) + Math.pow(((Point)this.points.get(i - 1)).getY() - ((Point)this.points.get(i)).getY(), 2.0));
            double dTime = (Long)this.time.get(i) - (Long)this.time.get(i - 1);
            double speed = 1000.0 * distance / dTime;
            this.data.add(speed);
            ++i;
        }
    }

    public void addPoint(Point p) {
        this.points.add(p);
        long curTime = System.currentTimeMillis();
        this.time.add(curTime);
    }

    public void clearPoints() {
        this.points.removeAllElements();
        this.time.removeAllElements();
        this.data.removeAllElements();
    }
}

