/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class MainFrame
extends JFrame {
    final int xSize = 600;
    final int ySize = 450;
    JButton button;
    Comm comm;
    JSplitPane splitPane;
    JPanel canvasPanel;
    JScrollPane canvasScrollPane;
    MyCanvas canvas;
    public boolean observer;
    FileDialog saveDialog;
    JToolBar toolSettingToolBar;
    private final MainFrame frame = this;
    private int i = 0;

    public MainFrame(Comm c, boolean observing) throws HeadlessException {
        super("Collaborative Painting");
        MainFrame.setDefaultLookAndFeelDecorated(true);
        this.setSize(600, 450);
        this.setDefaultCloseOperation(3);
        this.observer = observing;
        this.comm = c;
        this.initComponents();
        this.setVisible(true);
        this.splitPane.setLeftComponent(this.canvas.drawTool.settingPanel());
    }

    private void initComponents() {
        this.canvasPanel = new JPanel();
        this.canvas = new MyCanvas(this.comm, this, this.observer);
        this.canvasScrollPane = new JScrollPane(this.canvas);
        this.canvasPanel.add(this.canvasScrollPane);
        this.splitPane = new JSplitPane(1, this.canvas.drawTool.settingPanel(), this.canvasScrollPane);
        this.splitPane.setDividerLocation(100);
        this.splitPane.setDividerSize(3);
        if (!this.observer) {
            this.add(this.splitPane);
        } else {
            this.add(this.canvasScrollPane);
        }
        this.setJMenuBar(this.createMenuBar());
        if (!this.observer) {
            this.add((Component)this.selectToolBar(), "North");
        }
    }

    private JToolBar selectToolBar() {
        ButtonGroup bg = new ButtonGroup();
        JToolBar bar = new JToolBar();
        String[] icons = new String[]{"gbrush.png", "gpencil.png", "felttippen.png", "gpen.png", "pencil.gif", "line.gif", "rectangle.gif", "ellipse.gif", "rotrectangle.gif", "rotellipse.gif", "eraser.png", "gtext.png", "gstamp.png", "gpencil.png", "gpencil.png"};
        String[] toolTips = new String[]{"NPR water paint", "NPR pencil", "NPR felt-tip pen", "NPR ink pen", "Simple pen", "Line", "Rectangle", "Ellipse", "Rotated rectangle", "Rotated ellipse", "Eraser", "Text", "Stamp", "Text", "gpencil.png"};
        this.i = 0;
        while (this.i < this.canvas.toolsNumber()) {
            JToggleButton jb = new JToggleButton(new ImageIcon(icons[this.i]));
            jb.setToolTipText(toolTips[this.i]);
            jb.addActionListener(new ActionListener(){
                int p;
                {
                    this.p = MainFrame.this.i;
                }

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.canvas.setDrawTool(this.p);
                    ((MainFrame)MainFrame.this).frame.splitPane.setLeftComponent(MainFrame.this.canvas.drawTool.settingPanel());
                    MainFrame.this.splitPane.setDividerLocation(100);
                }
            });
            bar.add(jb);
            bg.add(jb);
            if (this.i == 0) {
                jb.setSelected(true);
            }
            if (this.i == 3 || this.i == 9) {
                bar.addSeparator();
            }
            ++this.i;
        }
        JButton colBut = new JButton(){
            public MyCanvas canv;
            public Color c;
            public JColorChooser colCh;
            public JDialog colDialog;
            {
                this.canv = MainFrame.this.canvas;
                this.c = Color.BLUE;
                this.colCh = new JColorChooser();
                this.colDialog = JColorChooser.createDialog(MainFrame.this.frame, "Choose foreground color", false, this.colCh, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        c = colCh.getColor();
                        canv.setToolColor(c);
                        this.repaint();
                    }
                }, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                    }
                });
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        colDialog.setVisible(true);
                    }
                });
                this.setToolTipText("Set foreground color");
            }

            public void paint(Graphics g) {
                g.setColor(this.c);
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g.setColor(Color.WHITE);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        };
        bar.addSeparator();
        bar.add(colBut);
        JButton colBut2 = new JButton(){
            public MyCanvas canv;
            public Color c;
            public JColorChooser colCh;
            public JDialog colDialog;
            {
                this.canv = MainFrame.this.canvas;
                this.c = Color.BLUE;
                this.colCh = new JColorChooser();
                this.colDialog = JColorChooser.createDialog(MainFrame.this.frame, "Choose background color", false, this.colCh, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        c = colCh.getColor();
                        canv.setToolBgColor(c);
                        this.repaint();
                    }
                }, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                    }
                });
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        colDialog.setVisible(true);
                    }
                });
                this.setToolTipText("Set background color");
            }

            public void paint(Graphics g) {
                g.setColor(this.c);
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g.setColor(Color.WHITE);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        };
        bar.addSeparator();
        bar.add(colBut2);
        return bar;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        menuBar.add(menuFile);
        this.saveDialog = new FileDialog((Frame)this, "Save drawing as..", 1);
        JMenuItem menuItemSave = new JMenuItem("Save drawing as PNG..");
        menuFile.add(menuItemSave);
        menuItemSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.saveDialog.show();
                try {
                    BufferedImage rgbClone = new BufferedImage(MainFrame.this.canvas.xSize, MainFrame.this.canvas.ySize, 1);
                    rgbClone.getGraphics().drawImage(MainFrame.this.canvas.image, 0, 0, null);
                    if (MainFrame.this.saveDialog.getFile() != null) {
                        ImageIO.write((RenderedImage)rgbClone, "png", new File(String.valueOf(MainFrame.this.saveDialog.getDirectory()) + MainFrame.this.saveDialog.getFile()));
                    }
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                }
            }
        });
        JMenuItem menuItemExit = new JMenuItem("Exit");
        menuFile.add(menuItemExit);
        menuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JMenu menuTool = new JMenu("Tool");
        menuBar.add(menuTool);
        JMenuItem menuItemShowChat = new JMenuItem("Show chat window");
        menuTool.add(menuItemShowChat);
        menuItemShowChat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.canvas.chatFrame.setVisible(true);
            }
        });
        menuTool.addSeparator();
        JMenuItem menuItemSendCanvas = new JMenuItem("Send whole canvas");
        menuTool.add(menuItemSendCanvas);
        if (!this.observer) {
            menuItemSendCanvas.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.canvas.sendTool(new Stamp(MainFrame.this.canvas.image));
                }
            });
        }
        JMenuItem menuItemClearCanvas = new JMenuItem("Clear whole canvas");
        menuTool.add(menuItemClearCanvas);
        if (!this.observer) {
            menuItemClearCanvas.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SimpleRectangle clr = new SimpleRectangle();
                    clr.alpha = 255;
                    clr.bgAlpha = 255;
                    clr.setColor(Color.WHITE);
                    clr.setBgColor(Color.WHITE);
                    clr.addPoint(new Point(0, 0));
                    clr.addPoint(new Point(MainFrame.this.canvas.xSize, MainFrame.this.canvas.ySize));
                    MainFrame.this.canvas.sendTool(clr);
                }
            });
        }
        JMenu menuHelp = new JMenu("Help");
        menuBar.add(menuHelp);
        JMenuItem menuItemAbout = new JMenuItem("About ..");
        menuHelp.add(menuItemAbout);
        menuItemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(MainFrame.this.frame, "Copyright (c) 2007 Milan Ruzicka", "About", 1);
            }
        });
        return menuBar;
    }

    public MainFrame(GraphicsConfiguration arg0) {
        super(arg0);
    }

    public MainFrame(String arg0) throws HeadlessException {
        super(arg0);
    }

    public MainFrame(String arg0, GraphicsConfiguration arg1) {
        super(arg0, arg1);
    }
}

