/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimpleEllipse
extends Tool {
    public final boolean drawable = true;
    private static final long serialVersionUID = 23L;
    public float width = 2.0f;
    public int alpha = 255;
    public int bgAlpha = 0;

    public SimpleEllipse() {
        this.points = new Vector();
        this.colors = new Vector();
        this.colors.add(Color.blue);
        this.colors.add(new Color(Color.blue.getRed(), Color.blue.getGreen(), Color.blue.getBlue(), this.bgAlpha));
    }

    public SimpleEllipse(Color c) {
        this.points = new Vector();
        this.colors = new Vector();
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.add(cc);
        this.colors.add(new Color(Color.blue.getRed(), Color.blue.getGreen(), Color.blue.getBlue(), this.bgAlpha));
    }

    public void draw(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke thindashed = new BasicStroke(this.width, 2, 1, 10.0f);
        g.setStroke(thindashed);
        int x = ((Point)this.points.firstElement()).x;
        int y = ((Point)this.points.firstElement()).y;
        int w = ((Point)this.points.lastElement()).x - ((Point)this.points.firstElement()).x;
        int h = ((Point)this.points.lastElement()).y - ((Point)this.points.firstElement()).y;
        if (w < 0) {
            x += w;
            w = Math.abs(w);
        }
        if (h < 0) {
            y += h;
            h = Math.abs(h);
        }
        g.setColor((Color)this.colors.get(1));
        g.fillArc(x, y, w, h, 0, 360);
        g.setColor((Color)this.colors.get(0));
        g.drawArc(x, y, w, h, 0, 360);
    }

    public void setColor(Color c) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.set(0, cc);
    }

    public void setBgColor(Color c) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.bgAlpha);
        this.colors.set(1, cc);
    }

    public void drawPreview(Graphics g1) {
        if (this.points.isEmpty()) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setColor(Color.GRAY);
        int x = ((Point)this.points.firstElement()).x;
        int y = ((Point)this.points.firstElement()).y;
        int w = ((Point)this.points.lastElement()).x - ((Point)this.points.firstElement()).x;
        int h = ((Point)this.points.lastElement()).y - ((Point)this.points.firstElement()).y;
        if (w < 0) {
            x += w;
            w = Math.abs(w);
        }
        if (h < 0) {
            y += h;
            h = Math.abs(h);
        }
        g.drawArc(x, y, w, h, 0, 360);
    }

    public JPanel settingPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Line width"));
        JSlider widthSlider = new JSlider(0, 0, 100, Math.round(this.width * 10.0f));
        widthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimpleEllipse.this.width = (float)((JSlider)e.getSource()).getValue() / 10.0f;
            }
        });
        widthSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(widthSlider);
        panel.add(new JLabel("Edge opacity"));
        JSlider alphaSlider = new JSlider(0, 0, 255, this.alpha);
        alphaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimpleEllipse.this.alpha = ((JSlider)e.getSource()).getValue();
                SimpleEllipse.this.setColor((Color)SimpleEllipse.this.colors.get(0));
            }
        });
        alphaSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(alphaSlider);
        panel.add(new JLabel("Interior opacity"));
        JSlider bgAlphaSlider = new JSlider(0, 0, 255, this.bgAlpha);
        bgAlphaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimpleEllipse.this.bgAlpha = ((JSlider)e.getSource()).getValue();
                SimpleEllipse.this.setBgColor((Color)SimpleEllipse.this.colors.get(1));
            }
        });
        bgAlphaSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(bgAlphaSlider);
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public boolean isDrawable() {
        return true;
    }
}

