/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimpleLine
extends Tool {
    public final boolean drawable = true;
    private static final long serialVersionUID = 21L;
    public float width = 2.0f;
    public int alpha = 255;

    public SimpleLine() {
        this.points = new Vector();
        this.colors = new Vector();
        this.colors.add(Color.blue);
        this.colors.add(Color.blue);
    }

    public SimpleLine(Color c) {
        this.points = new Vector();
        this.colors = new Vector();
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.add(cc);
        this.colors.add(Color.blue);
    }

    public void draw(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke thindashed = new BasicStroke(this.width, 2, 1, 10.0f);
        g.setStroke(thindashed);
        g.setColor((Color)this.colors.get(0));
        int x = ((Point)this.points.firstElement()).x;
        int y = ((Point)this.points.firstElement()).y;
        int w = ((Point)this.points.lastElement()).x - ((Point)this.points.firstElement()).x;
        int h = ((Point)this.points.lastElement()).y - ((Point)this.points.firstElement()).y;
        g.drawLine(x, y, x + w, y + h);
    }

    public void setColor(Color c) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.set(0, cc);
    }

    public void drawPreview(Graphics g1) {
        if (this.points.isEmpty()) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setColor(Color.GRAY);
        int x = ((Point)this.points.firstElement()).x;
        int y = ((Point)this.points.firstElement()).y;
        int w = ((Point)this.points.lastElement()).x - ((Point)this.points.firstElement()).x;
        int h = ((Point)this.points.lastElement()).y - ((Point)this.points.firstElement()).y;
        g.drawLine(x, y, x + w, y + h);
    }

    public JPanel settingPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Line width"));
        JSlider widthSlider = new JSlider(0, 0, 100, Math.round(this.width * 10.0f));
        widthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimpleLine.this.width = (float)((JSlider)e.getSource()).getValue() / 10.0f;
            }
        });
        widthSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(widthSlider);
        panel.add(new JLabel("Opacity"));
        JSlider alphaSlider = new JSlider(0, 0, 255, this.alpha);
        alphaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimpleLine.this.alpha = ((JSlider)e.getSource()).getValue();
                SimpleLine.this.setColor((Color)SimpleLine.this.colors.get(0));
            }
        });
        alphaSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(alphaSlider);
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public boolean isDrawable() {
        return true;
    }
}

