/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Stamp
extends Tool {
    public final boolean drawable = true;
    private static final long serialVersionUID = 31L;
    public float size = 1.0f;
    public int alpha = 255;
    ImageIcon ii;

    public Stamp() {
        this.points = new Vector();
        this.colors = new Vector();
        this.colors.add(Color.blue);
        this.colors.add(Color.blue);
    }

    public Stamp(Image bi) {
        this();
        this.ii = new ImageIcon(bi);
        this.points.add(new Point(bi.getWidth(null) / 2, bi.getHeight(null) / 2));
    }

    public Stamp(JFrame f) {
        this();
    }

    public Stamp(MyCanvas mc) {
        this();
    }

    public Stamp(Color c) {
        this.points = new Vector();
        this.colors = new Vector();
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.add(cc);
        this.colors.add(Color.blue);
    }

    public void draw(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke thindashed = new BasicStroke(this.size, 2, 1, 10.0f);
        g.setStroke(thindashed);
        g.setColor((Color)this.colors.get(0));
        AffineTransform at = new AffineTransform();
        double angle = this.angle;
        AffineTransform at2 = new AffineTransform();
        at2.setToRotation(-angle);
        Point p0 = (Point)this.points.firstElement();
        Point p1 = (Point)this.points.lastElement();
        int x = at2.createTransformedShape((Shape)new Rectangle((Point)p0)).getBounds().x;
        int y = at2.createTransformedShape((Shape)new Rectangle((Point)p0)).getBounds().y;
        int x1 = at2.createTransformedShape((Shape)new Rectangle((Point)p1)).getBounds().x;
        int y1 = at2.createTransformedShape((Shape)new Rectangle((Point)p1)).getBounds().y;
        int w = x1 - x;
        int h = y1 - y;
        if (w < 0) {
            x += w;
            w = Math.abs(w);
        }
        if (h < 0) {
            y += h;
            h = Math.abs(h);
        }
        int wid = this.ii.getImage().getWidth(null);
        int hei = this.ii.getImage().getHeight(null);
        at.setToTranslation((float)p1.x - (float)wid * this.size / 2.0f, (float)p1.y - (float)hei * this.size / 2.0f);
        at.scale(this.size, this.size);
        at.rotate(angle);
        g.setTransform(at);
        if (this.ii != null) {
            g.drawImage(this.ii.getImage(), 0, 0, null);
        }
    }

    public void setColor(Color c) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
        this.colors.set(0, cc);
    }

    public void drawPreview(Graphics g1) {
        if (this.points.isEmpty()) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        AffineTransform at = new AffineTransform();
        double angle = this.angle;
        at.setToRotation(angle);
        AffineTransform at2 = new AffineTransform();
        at2.setToRotation(-angle);
        g.setColor(Color.GRAY);
        Point p0 = (Point)this.points.firstElement();
        Point p1 = (Point)this.points.lastElement();
        int x = at2.createTransformedShape((Shape)new Rectangle((Point)p0)).getBounds().x;
        int y = at2.createTransformedShape((Shape)new Rectangle((Point)p0)).getBounds().y;
        int x1 = at2.createTransformedShape((Shape)new Rectangle((Point)p1)).getBounds().x;
        int y1 = at2.createTransformedShape((Shape)new Rectangle((Point)p1)).getBounds().y;
        int w = x1 - x;
        int h = y1 - y;
        if (w < 0) {
            x += w;
            w = Math.abs(w);
        }
        if (h < 0) {
            y += h;
            h = Math.abs(h);
        }
        int wid = this.ii.getImage().getWidth(null);
        int hei = this.ii.getImage().getHeight(null);
        at.setToTranslation((float)p1.x - (float)wid * this.size / 2.0f, (float)p1.y - (float)hei * this.size / 2.0f);
        at.scale(this.size, this.size);
        at.rotate(angle);
        g.setTransform(at);
        if (this.ii != null) {
            g.drawImage(this.ii.getImage(), 0, 0, null);
        }
    }

    public JPanel settingPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Set scale:"));
        JSlider widthSlider = new JSlider(0, 1, 100, Math.round(this.size * 10.0f));
        widthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Stamp.this.size = (float)((JSlider)e.getSource()).getValue() / 10.0f;
            }
        });
        widthSlider.setPreferredSize(new Dimension(50, 20));
        panel.add(widthSlider);
        panel.add(new JLabel("Orientation"));
        AngleChooser angleChooser = new AngleChooser(this, this.angle);
        panel.add(angleChooser);
        JButton previewPanel = new JButton(){
            private ImageIcon iii;
            {
                this.iii = Stamp.this.ii;
                this.setSize(80, 80);
                this.setPreferredSize(new Dimension(80, 80));
            }

            public void paint(Graphics g1) {
                if (Stamp.this.ii == null) {
                    g1.setColor(Color.WHITE);
                    g1.fillRect(0, 0, this.getWidth(), this.getHeight());
                    String msg1 = "Click";
                    String msg2 = "to load";
                    String msg3 = "image ...";
                    g1.setColor(Color.BLACK);
                    g1.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    g1.drawBytes(msg1.getBytes(), 0, msg1.length(), this.getWidth() / 2 - 20, this.getHeight() / 2 - 15);
                    g1.drawBytes(msg2.getBytes(), 0, msg2.length(), this.getWidth() / 2 - 23, this.getHeight() / 2);
                    g1.drawBytes(msg3.getBytes(), 0, msg3.length(), this.getWidth() / 2 - 25, this.getHeight() / 2 + 15);
                } else {
                    Graphics2D g2 = (Graphics2D)g1;
                    g2.setColor(Color.white);
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    AffineTransform at = new AffineTransform();
                    at.setToScale((double)this.getWidth() / (double)Stamp.this.ii.getIconWidth(), (double)this.getHeight() / (double)Stamp.this.ii.getIconHeight());
                    g2.drawImage(Stamp.this.ii.getImage(), at, null);
                }
            }
        };
        panel.add(new JLabel("Preview"));
        previewPanel.addActionListener(new ActionListener(){
            FileDialog loadDialog = new FileDialog((Frame)new JFrame(), "Load stamp from file ..", 0);

            public void actionPerformed(ActionEvent e) {
                this.loadDialog.show();
                if (this.loadDialog.getFile() != null) {
                    Stamp.this.ii = new ImageIcon(String.valueOf(this.loadDialog.getDirectory()) + this.loadDialog.getFile());
                    if (Stamp.this.ii.getImage().getWidth(null) == -1) {
                        Stamp.this.ii = null;
                    }
                }
            }
        });
        panel.add(previewPanel);
        return panel;
    }

    public boolean isDrawable() {
        return true;
    }
}

