import java.awt.Point;
import java.util.Vector;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.BasicStroke;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import java.awt.Dimension;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;

import javax.swing.BoxLayout;

/**
 * @author Milan Ruzicka
 *
 */
public class SimpleEllipse extends Tool {
	public final boolean drawable = true;
	private static final long serialVersionUID = 23L; 
	
	public float width = 2.0f;
	public int alpha = 255;
	public int bgAlpha = 0;
	
	/**
	 * 
	 */	
	public SimpleEllipse() {
		points = new Vector();
		colors = new Vector();
		
		colors.add(Color.blue);
		colors.add(new Color(Color.blue.getRed(),Color.blue.getGreen(),Color.blue.getBlue(),bgAlpha));
		
	}
	
	public SimpleEllipse(Color c) {
		points = new Vector();
		colors = new Vector();
		
		Color cc = new Color(c.getRed(),c.getGreen(),c.getBlue(),alpha);
		colors.add(cc);
		colors.add(new Color(Color.blue.getRed(),Color.blue.getGreen(),Color.blue.getBlue(),bgAlpha));
	}

	/* (non-Javadoc)
	 * @see Tool#draw(java.awt.Image)
	 */
	@Override
	public void draw(Graphics g1) {
		Graphics2D g = (Graphics2D) g1;
				
		g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		  Stroke thindashed = new BasicStroke(width, // line width
			      /* cap style */BasicStroke.CAP_SQUARE,
			      /* join style, miter limit */BasicStroke.JOIN_ROUND, 10.0f);//,
			      /* the dash pattern *///new float[] { 8.0f, 3.0f, 2.0f, 3.0f },
			      /* the dash phase *///0.0f); /* on 8, off 3, on 2, off 3 */
		g.setStroke(thindashed);
		
		int x = ((Point)points.firstElement()).x;
		int y = ((Point)points.firstElement()).y;
		int w = ((Point)points.lastElement()).x - ((Point)points.firstElement()).x;
		int h = ((Point)points.lastElement()).y - ((Point)points.firstElement()).y;
		if (w < 0) { x += w; w = Math.abs(w); }
		if (h < 0) { y += h; h = Math.abs(h); }
		
		g.setColor((Color) colors.get(1));
		g.fillArc(x, y, w, h,0,360);
		
		g.setColor((Color) colors.get(0));
		g.drawArc(x, y, w, h,0,360);
		
	}
	
	public void setColor(Color c){
		Color cc = new Color(c.getRed(),c.getGreen(),c.getBlue(),alpha);
		colors.set(0, cc);
	}
	
	public void setBgColor(Color c){
		Color cc = new Color(c.getRed(),c.getGreen(),c.getBlue(),bgAlpha);
		colors.set(1, cc);
	}
	
	public void drawPreview(Graphics g1) {
		if (points.isEmpty()) return;
		
		Graphics2D g = (Graphics2D) g1;
	
		g.setColor(Color.GRAY);
		
		int x = ((Point)points.firstElement()).x;
		int y = ((Point)points.firstElement()).y;
		int w = ((Point)points.lastElement()).x - ((Point)points.firstElement()).x;
		int h = ((Point)points.lastElement()).y - ((Point)points.firstElement()).y;
		if (w < 0) { x += w; w = Math.abs(w); }
		if (h < 0) { y += h; h = Math.abs(h); }
		
		g.drawArc(x, y, w, h, 0, 360);
		
	}
	
	public JPanel settingPanel(){
		JPanel panel = new JPanel();
		
		panel.add(new JLabel("Line width"));
		
		JSlider widthSlider = new JSlider(JSlider.HORIZONTAL,0,100,Math.round(width*10f));
		widthSlider.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				width = (float)((JSlider)e.getSource()).getValue()/10f;
			}
		});
		widthSlider.setPreferredSize(new Dimension(50,20));
        panel.add(widthSlider);
        
        
        panel.add(new JLabel("Edge opacity"));
        
		JSlider alphaSlider = new JSlider(JSlider.HORIZONTAL,0,255,alpha);
		alphaSlider.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				alpha = (int)((JSlider)e.getSource()).getValue();
				setColor((Color)colors.get(0));
			}
		});
		alphaSlider.setPreferredSize(new Dimension(50,20));
        panel.add(alphaSlider);
        
        
        panel.add(new JLabel("Interior opacity"));        
        
		JSlider bgAlphaSlider = new JSlider(JSlider.HORIZONTAL,0,255,bgAlpha);
		bgAlphaSlider.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
				bgAlpha = (int)((JSlider)e.getSource()).getValue();
				setBgColor((Color)colors.get(1));
			}
		});
		bgAlphaSlider.setPreferredSize(new Dimension(50,20));
        panel.add(bgAlphaSlider);
        
        panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
		return panel;
	}

	public boolean isDrawable(){
		return true;
	}
}