/*
 * Decompiled with CFR 0.152.
 */
package bmsi.util;

import bmsi.util.Diff;
import bmsi.util.UnaryPredicate;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;

public class DiffPrint {
    static String[] slurp(String file) throws IOException {
        String line;
        BufferedReader rdr = new BufferedReader(new FileReader(file));
        Vector<String> s = new Vector<String>();
        while ((line = rdr.readLine()) != null) {
            s.addElement(line);
        }
        Object[] a = new String[s.size()];
        s.copyInto(a);
        return a;
    }

    public static void main(String[] argv) throws IOException {
        boolean edstyle;
        Object[] b;
        Object[] a = DiffPrint.slurp(argv[argv.length - 2]);
        Diff d = new Diff(a, b = DiffPrint.slurp(argv[argv.length - 1]));
        Diff.change script = d.diff_2(edstyle = "-e".equals(argv[0]));
        if (script == null) {
            System.err.println("No differences");
        } else {
            Base p = edstyle ? new EdPrint(a, b) : new NormalPrint(a, b);
            p.print_script(script);
        }
    }

    public static class EdPrint
    extends Base {
        public EdPrint(Object[] a, Object[] b) {
            super(a, b);
        }

        @Override
        protected void print_hunk(Diff.change hunk) {
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.print_number_range(',', this.first0, this.last0);
            this.outfile.println(EdPrint.change_letter(this.inserts, this.deletes));
            if (this.inserts != 0) {
                boolean inserting = true;
                for (int i = this.first1; i <= this.last1; ++i) {
                    if (!inserting) {
                        this.outfile.println(i - this.first1 + this.first0 + "a");
                    }
                    inserting = true;
                    if (".".equals(this.file1[i])) {
                        this.outfile.println("..");
                        this.outfile.println(".");
                        this.outfile.println(i - this.first1 + this.first0 + 1 + "s/^\\.\\././");
                        inserting = false;
                        continue;
                    }
                    this.print_1_line("", this.file1[i]);
                }
                if (inserting) {
                    this.outfile.println(".");
                }
            }
        }
    }

    public static class NormalPrint
    extends Base {
        public NormalPrint(Object[] a, Object[] b) {
            super(a, b);
        }

        @Override
        protected void print_hunk(Diff.change hunk) {
            int i;
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.print_number_range(',', this.first0, this.last0);
            this.outfile.print(NormalPrint.change_letter(this.inserts, this.deletes));
            this.print_number_range(',', this.first1, this.last1);
            this.outfile.println();
            if (this.deletes != 0) {
                for (i = this.first0; i <= this.last0; ++i) {
                    this.print_1_line("< ", this.file0[i]);
                }
            }
            if (this.inserts != 0 && this.deletes != 0) {
                this.outfile.println("---");
            }
            if (this.inserts != 0) {
                for (i = this.first1; i <= this.last1; ++i) {
                    this.print_1_line("> ", this.file1[i]);
                }
            }
        }
    }

    public static abstract class Base {
        protected UnaryPredicate ignore = null;
        protected Object[] file0;
        protected Object[] file1;
        protected int first0;
        protected int last0;
        protected int first1;
        protected int last1;
        protected int deletes;
        protected int inserts;
        protected PrintWriter outfile = new PrintWriter(new OutputStreamWriter(System.out));

        protected Base(Object[] a, Object[] b) {
            this.file0 = a;
            this.file1 = b;
        }

        public void setWriter(PrintWriter writer) {
            this.outfile = writer;
        }

        public void print_script(Diff.change script) {
            Diff.change next = script;
            while (next != null) {
                Diff.change t = next;
                Diff.change end = this.hunkfun(next);
                next = end.link;
                end.link = null;
                this.print_hunk(t);
                end.link = next;
            }
            this.outfile.flush();
        }

        protected Diff.change hunkfun(Diff.change hunk) {
            return hunk;
        }

        protected void analyze_hunk(Diff.change hunk) {
            int l0 = 0;
            int l1 = 0;
            int show_from = 0;
            int show_to = 0;
            boolean nontrivial = this.ignore == null;
            show_to = 0;
            show_from = 0;
            int f0 = hunk.line0;
            int f1 = hunk.line1;
            Diff.change next = hunk;
            while (next != null) {
                int i;
                l0 = next.line0 + next.deleted - 1;
                l1 = next.line1 + next.inserted - 1;
                show_from += next.deleted;
                show_to += next.inserted;
                for (i = next.line0; i <= l0 && !nontrivial; ++i) {
                    if (this.ignore.execute(this.file0[i])) continue;
                    nontrivial = true;
                }
                for (i = next.line1; i <= l1 && !nontrivial; ++i) {
                    if (this.ignore.execute(this.file1[i])) continue;
                    nontrivial = true;
                }
                next = next.link;
            }
            this.first0 = f0;
            this.last0 = l0;
            this.first1 = f1;
            this.last1 = l1;
            if (!nontrivial) {
                show_to = 0;
                show_from = 0;
            }
            this.deletes = show_from;
            this.inserts = show_to;
        }

        protected abstract void print_hunk(Diff.change var1);

        protected void print_1_line(String pre, Object linbuf) {
            this.outfile.println(pre + linbuf.toString());
        }

        protected void print_number_range(char sepchar, int a, int b) {
            if (++b > ++a) {
                this.outfile.print("" + a + sepchar + b);
            } else {
                this.outfile.print(b);
            }
        }

        public static char change_letter(int inserts, int deletes) {
            if (inserts == 0) {
                return 'd';
            }
            if (deletes == 0) {
                return 'a';
            }
            return 'c';
        }
    }
}

