/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf;

import calhoun.util.Assert;
import java.util.ArrayList;

public class CacheStrategySpec {
    public CacheStrategy strategy;
    public Object details;

    public CacheStrategySpec(CacheStrategy strategy, Object details) {
        this.strategy = strategy;
        this.details = details;
    }

    public CacheStrategySpec(CacheStrategy strategy) {
        this(strategy, null);
    }

    public static class DenseBoundaryEntry {
        public int potential;
        public int tableNum;
        public int featureIndex;
        public int rightPad;
        public int leftPad;

        public DenseBoundaryEntry(int potential, int tableNum, int featureIndex, int rightPad, int leftPad) {
            this.potential = potential;
            this.tableNum = tableNum;
            this.featureIndex = featureIndex;
            this.rightPad = rightPad;
            this.leftPad = leftPad;
            this.check();
        }

        private void check() {
            Assert.a(this.potential >= 0);
            Assert.a(this.tableNum >= 0);
            Assert.a(this.featureIndex >= 0);
            Assert.a(this.rightPad >= 0);
            Assert.a(this.leftPad >= 0);
        }
    }

    public static class DenseBoundaryCachingDetails {
        public int nTables;
        public ArrayList<DenseBoundaryEntry> entries;

        public DenseBoundaryCachingDetails(int nTables) {
            this.nTables = nTables;
            this.entries = new ArrayList();
        }

        public void add(int potential, int tableNum, int featureIndex, int rightPad, int leftPad) {
            this.entries.add(new DenseBoundaryEntry(potential, tableNum, featureIndex, rightPad, leftPad));
        }

        public void check() {
            int maxTable = 0;
            for (int j = 0; j < this.entries.size(); ++j) {
                DenseBoundaryEntry dbe = this.entries.get(j);
                dbe.check();
                int tnum = dbe.tableNum;
                if (tnum <= maxTable) continue;
                maxTable = tnum;
            }
            Assert.a(maxTable == this.nTables - 1);
        }
    }

    public static class DenseCachingDetails {
        public int nTables;
        public int nEvals;
        public int[] potential;
        public int[] tableNum;
        public short[] featureIndex;

        public void check() {
            Assert.a(this.nTables >= 0);
            Assert.a(this.potential.length == this.nEvals);
            Assert.a(this.tableNum.length == this.nEvals);
            Assert.a(this.featureIndex.length == this.nEvals);
            for (int j = 0; j < this.nEvals; ++j) {
                Assert.a(this.potential[j] >= 0);
                Assert.a(this.tableNum[j] >= 0);
                Assert.a(this.tableNum[j] < this.nTables);
                Assert.a(this.featureIndex[j] >= 0);
            }
        }
    }

    public static enum CacheStrategy {
        COMPOSITE,
        CONSTANT,
        SPARSE,
        UNSPECIFIED,
        DENSE_NODE_BOUNDARY,
        DENSE,
        LENGTHFUNCTION;

    }
}

