/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.executables;

import calhoun.analysis.crf.CRFObjectiveFunctionGradient;
import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.CacheProcessor;
import calhoun.analysis.crf.solver.CacheProcessorDeluxe;
import calhoun.analysis.crf.solver.MaximumLikelihoodGradient;
import calhoun.analysis.crf.solver.MaximumLikelihoodSemiMarkovGradient;
import calhoun.analysis.crf.solver.StandardOptimizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FeatureInspector
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 4470742291972538174L;
    private static final int WINDOW_WIDTH = 800;
    private static final int WINDOW_HEIGHT = 600;
    CacheProcessorDeluxe cp;
    JTextField seq = new JTextField(5);
    JTextField start = new JTextField(5);
    JTextField end = new JTextField(5);
    JTextField from = new JTextField(5);
    JTextField to = new JTextField(5);
    JTextArea results = new JTextArea("Results:", 20, 40);

    public FeatureInspector() throws IOException {
        super("Feature Inspector");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel overall = new JPanel();
        overall.setLayout(new BorderLayout());
        JPanel pane = new JPanel();
        pane.add(new JLabel("Seq:"));
        pane.add(this.seq);
        pane.add(new JLabel("Start pos:"));
        pane.add(this.start);
        pane.add(new JLabel("End pos:"));
        pane.add(this.end);
        pane.add(new JLabel("From:"));
        pane.add(this.from);
        pane.add(new JLabel("To:"));
        pane.add(this.to);
        JButton button = new JButton("GetFeatures");
        button.addActionListener(this);
        pane.add(button);
        overall.add((Component)pane, "North");
        overall.add((Component)this.results, "South");
        this.setContentPane(overall);
        this.setSize(800, 600);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            args = new String[]{"test/working/interval13BaselineModelTest2.ser", "test/input/interval13/data/oneGeneTrain.interval13.txt"};
        }
        Conrad c = Conrad.read(args[0]);
        List<? extends TrainingSequence<?>> data = c.getInputHandler().readTrainingData(args[1]);
        CRFObjectiveFunctionGradient crf = ((StandardOptimizer)c.getOptimizer()).getObjectiveFunction();
        CacheProcessor cp = crf instanceof MaximumLikelihoodSemiMarkovGradient ? ((MaximumLikelihoodSemiMarkovGradient)crf).getCacheProcessor() : ((MaximumLikelihoodGradient)crf).getCacheProcessor();
        cp.setTrainingData(c.getModel(), data);
        FeatureInspector app = new FeatureInspector();
        app.cp = (CacheProcessorDeluxe)cp;
        app.pack();
        app.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.results.setText(this.getMessage());
        this.invalidate();
    }

    String getMessage() {
        CacheProcessor.FeatureEvaluation eval;
        int seqNum = Integer.parseInt(this.seq.getText());
        int e = Integer.parseInt(this.end.getText());
        int t = Integer.parseInt(this.to.getText());
        int s = Integer.MIN_VALUE;
        if (this.start.getText().length() > 0) {
            s = Integer.parseInt(this.start.getText());
        }
        int f = Integer.MIN_VALUE;
        if (this.from.getText().length() > 0) {
            f = Integer.parseInt(this.from.getText());
        }
        CacheProcessor.SolverSetup solverSetup = this.cp.getSolverSetup();
        StringBuffer b = new StringBuffer();
        if (s == Integer.MIN_VALUE) {
            int potential;
            this.cp.evaluatePosition(seqNum, e);
            if (f == Integer.MIN_VALUE) {
                potential = t;
            } else {
                potential = solverSetup.transitionIndex.getQuick(f, t) + solverSetup.nStates;
                if (potential == -1 + solverSetup.nStates) {
                    return "Transition is not in model.";
                }
            }
            eval = this.cp.getFeatureEvaluations()[potential];
            if (this.cp.invalidTransitions[(solverSetup.seqOffsets[seqNum] + e) * solverSetup.nPotentials + t]) {
                return "Invalid node";
            }
            if (this.cp.invalidTransitions[(solverSetup.seqOffsets[seqNum] + e) * solverSetup.nPotentials + potential]) {
                return "Invalid edge";
            }
        } else {
            this.cp.evaluateSegmentsEndingAt(seqNum, e);
            CacheProcessor.LengthFeatureEvaluation[][] l = this.cp.getLengthFeatureEvaluations();
            int stateIx = 0;
            while (solverSetup.statesWithLookback[stateIx].state != t) {
                if (++stateIx != solverSetup.statesWithLookback.length) continue;
                return "State " + t + " is not a semi-Markov state.";
            }
            int lookbackIx = 0;
            while (l[stateIx][lookbackIx].lookback != e - s) {
                if (l[stateIx][lookbackIx].lookback == -1) {
                    return "Lookback is not valid.";
                }
                ++lookbackIx;
            }
            b.append("Node features only:\n");
            eval = l[stateIx][lookbackIx].nodeEval;
        }
        int i = 0;
        while (eval.index[i] != -1) {
            b.append(eval.index[i]).append(": ").append(eval.value[i]).append("\n");
            ++i;
        }
        if (i == 0) {
            return "No features";
        }
        return b.toString();
    }
}

