/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.executables;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.io.SequenceConverter;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import calhoun.util.FileUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HiddenSequenceConverter {
    private static void explainUsage() {
        System.err.println("Usage error.  Call must be the following format:");
        System.err.println("> HiddenSequenceConverter 13to39 <config file> <input file> <output file>");
        System.err.println("> HiddenSequenceConverter 39to13 <config file> <input file> <output file>");
        System.err.println("> HiddenSequenceConverter tricycle13ToInterval13 <config file> <input file> <output file>");
        System.err.println("> HiddenSequenceConverter interval13ToTricycle13 <config file> <input file> <output file>");
        System.err.println("> HiddenSequenceConverter tricycle13ToInterval13 <input file.dat> <output file.dat>");
        System.err.println("> HiddenSequenceConverter interval13ToTricycle13 <input file.dat> <output file.dat>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        String convertType;
        if (args.length < 3 || args.length > 4) {
            System.out.println("ERROR - number of args is less than 3 or greater than 4");
            HiddenSequenceConverter.explainUsage();
        }
        if (args.length == 3) {
            System.out.println("Hidden Sequence Converter");
            convertType = args[0];
            String inputFile = args[1];
            String outputFile = args[2];
            String[] data = FileUtil.readLines(inputFile);
            BufferedWriter w = new BufferedWriter(new FileWriter(outputFile));
            System.out.println("Size of data is " + data.length);
            for (int j = 0; j < data.length; ++j) {
                if (convertType.equals("tricycle13ToInterval13")) {
                    w.write(SequenceConverter.convertSeqFromTricycle13ToInterval13(data[j]) + "\n");
                    continue;
                }
                if (convertType.equals("interval13ToTricycle13")) {
                    w.write(SequenceConverter.convertSeqFromInterval13ToTricycle13(data[j]) + "\n");
                    continue;
                }
                System.out.println("ERROR - convertType is not recognized");
                HiddenSequenceConverter.explainUsage();
                Assert.a(false, "convertType = " + convertType);
            }
            w.close();
        }
        if (args.length == 4) {
            System.out.println("Hidden Sequence Converter");
            convertType = args[0];
            String configFile = args[1];
            String inputFile = args[2];
            String outputFile = args[3];
            Conrad crf = new Conrad(configFile);
            List<TrainingSequence<?>> data = crf.getInputHandler().readTrainingData(inputFile);
            ArrayList listOfSeqs = new ArrayList();
            for (int i = 0; i < data.size(); ++i) {
                TrainingSequence<?> seq = data.get(i);
                System.out.println("Converting sequence " + i + ".");
                if (convertType.equals("13to39")) {
                    SequenceConverter.convertSeqFrom13To39(seq.getTrainingComponent("ref"));
                } else if (convertType.equals("39to13")) {
                    SequenceConverter.convertSeqFrom39To13(seq.getTrainingComponent("ref"));
                } else if (convertType.equals("tricycle13ToInterval13")) {
                    SequenceConverter.convertSeqFromTricycle13ToInterval13(seq.getTrainingComponent("ref"));
                } else if (convertType.equals("interval13ToTricycle13")) {
                    SequenceConverter.convertSeqFromInterval13ToTricycle13(seq.getTrainingComponent("ref"));
                } else {
                    HiddenSequenceConverter.explainUsage();
                    Assert.a(false, "convertType = " + convertType);
                }
                listOfSeqs.add(seq);
            }
            crf.getInputHandler().writeTrainingData(outputFile, listOfSeqs);
        }
        System.out.println("DONE");
    }
}

