/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.executables;

import calhoun.util.FileUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import java.io.File;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class JFreeChartUI
extends ApplicationFrame {
    private static final long serialVersionUID = 3968640935099256212L;
    static String[] models = new String[]{""};

    public JFreeChartUI(JPanel chartPanel, String title) {
        super(title);
        chartPanel.setPreferredSize(new Dimension(1000, 700));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) throws Exception {
        for (String model : models) {
            JFreeChartUI demo = new JFreeChartUI((JPanel)JFreeChartUI.createChart(model), model);
            demo.pack();
            RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
            demo.setVisible(true);
        }
    }

    static ChartPanel createChart(String model) throws Exception {
        DefaultStatisticalCategoryDataset dataset = (DefaultStatisticalCategoryDataset)FileUtil.readObject(model + "Chart.dat");
        JFreeChart chart = JFreeChartUI.createChart((CategoryDataset)dataset);
        ChartUtilities.saveChartAsPNG((File)new File(model + "Weights.png"), (JFreeChart)chart, (int)1000, (int)700);
        return new ChartPanel(chart);
    }

    private static JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart(null, (String)"Features", (String)"Weights", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAxisLineVisible(false);
        rangeAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        rangeAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setNumberFormatOverride((NumberFormat)new NumberFormatMine());
        StatisticalBarRenderer renderer = new StatisticalBarRenderer();
        renderer.setBaseFillPaint((Paint)Color.blue);
        renderer.setErrorIndicatorPaint((Paint)Color.black);
        renderer.setIncludeBaseInRange(false);
        plot.setRenderer((CategoryItemRenderer)renderer);
        renderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)new NumberFormatMine()));
        renderer.setBaseItemLabelsVisible(true);
        renderer.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.INSIDE6, TextAnchor.BOTTOM_CENTER));
        return chart;
    }

    static class NumberFormatMine
    extends DecimalFormat {
        private static final long serialVersionUID = -2978723914826541314L;

        NumberFormatMine() {
        }

        @Override
        public StringBuffer format(double arg0, StringBuffer arg1, FieldPosition arg2) {
            StringBuffer ret = super.format(arg0, arg1, arg2);
            System.out.println(ret);
            return ret;
        }
    }
}

