/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.executables;

import calhoun.util.FileUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.geom.Ellipse2D;
import java.io.File;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class JFreeChartUI2
extends ApplicationFrame {
    private static final long serialVersionUID = 2121829480061443584L;

    public JFreeChartUI2(JPanel chartPanel, String title) {
        super(title);
        chartPanel.setPreferredSize(new Dimension(1000, 700));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) throws Exception {
        JFreeChartUI2.load("nuc");
        JFreeChartUI2.load("exon");
        JFreeChartUI2.load("gene");
    }

    static void load(String val) throws Exception {
        JPanel panel = JFreeChartUI2.loadChart(val);
        JFreeChartUI2 demo = new JFreeChartUI2(panel, val);
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }

    static JPanel loadChart(String type) throws Exception {
        DefaultStatisticalCategoryDataset dataset = (DefaultStatisticalCategoryDataset)FileUtil.readObject(type + ".dat");
        JFreeChart chart = JFreeChartUI2.createChart((CategoryDataset)dataset);
        ChartUtilities.saveChartAsPNG((File)new File(type + ".png"), (JFreeChart)chart, (int)1000, (int)700);
        return new ChartPanel(chart);
    }

    private static JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart(null, (String)"Training set size", (String)"Accuracy", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAxisLineVisible(false);
        rangeAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        rangeAxis.setUpperBound(1.0);
        rangeAxis.setAutoRange(true);
        StatisticalLineAndShapeRenderer renderer = new StatisticalLineAndShapeRenderer();
        plot.setRenderer((CategoryItemRenderer)renderer);
        renderer.setShapesVisible(true);
        renderer.setDrawOutlines(true);
        renderer.setUseFillPaint(true);
        renderer.setFillPaint((Paint)Color.white);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(3.0f));
        renderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(2.0f));
        renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
        return chart;
    }
}

