/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.executables;

import calhoun.analysis.crf.Conrad;
import calhoun.util.Assert;
import calhoun.util.FileUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;

public class PrintWeights {
    static String[] models = new String[]{"CND1_600/crypto_2way_mean_CND1_600", "AN1_AF2/comp_mean_AN1_AF2"};
    static String template = "y:/scripts/conrad/daved/results/";

    public static void main(String[] args) throws Exception {
        DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
        for (String model : models) {
            PrintWeights.chart(dataset, template, model);
        }
        FileUtil.writeObject("Chart.dat", dataset);
        FileUtil.writeFile("weights.txt", PrintWeights.printSet(dataset));
    }

    static String printSet(DefaultStatisticalCategoryDataset set) {
        int col;
        StringBuffer buf = new StringBuffer();
        for (col = 0; col < set.getRowCount(); ++col) {
            if (col != 0) {
                buf.append("\t");
            }
            buf.append(set.getRowKey(col));
        }
        for (col = 0; col < set.getRowCount(); ++col) {
            buf.append("\t").append(set.getRowKey(col) + "StdDev");
        }
        buf.append("\n");
        for (int row = 0; row < set.getColumnCount(); ++row) {
            int col2;
            buf.append(set.getColumnKey(row));
            for (col2 = 0; col2 < set.getRowCount(); ++col2) {
                buf.append("\t").append(PrintWeights.safePrint(set.getMeanValue(col2, row)));
            }
            for (col2 = 0; col2 < set.getRowCount(); ++col2) {
                buf.append("\t").append(PrintWeights.safePrint(set.getStdDevValue(col2, row)));
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    static String safePrint(Object o) {
        return o == null ? "" : o.toString();
    }

    public static void chart(DefaultStatisticalCategoryDataset dataset, String template, String model) throws Exception {
        int REP = 10;
        double[][] weights = new double[REP][];
        Conrad r = null;
        int len = -1;
        for (int i = 0; i < REP; ++i) {
            String file = template + model + "_" + i + ".ser";
            System.out.println(file);
            try {
                r = Conrad.read(file);
                weights[i] = r.getWeights();
                len = weights[i].length;
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.out.println("Skipping " + file + " " + ex.getMessage());
                weights[i] = new double[len];
            }
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < r.getNumFeatures(); ++i) {
            names.add(r.getFeatureName(i));
        }
        DefaultStatisticalCategoryDataset localDataset = new DefaultStatisticalCategoryDataset();
        Assert.a(r.getNumFeatures() == weights[REP - 1].length, r.getNumFeatures(), " ", weights[REP - 1].length);
        Assert.a(names.size() == weights[REP - 1].length, names.size(), " ", weights[REP - 1].length);
        StringBuffer b = new StringBuffer();
        double[] featureWeights = new double[REP];
        System.out.println(names.size());
        System.out.println(weights[REP - 1].length);
        for (int j = 0; j < names.size(); ++j) {
            b.append((String)names.get(j));
            for (int i = 0; i < REP; ++i) {
                featureWeights[i] = weights[i][j];
            }
            b.append("\t").append(StatUtils.mean((double[])featureWeights));
            StandardDeviation s = new StandardDeviation();
            b.append("\t").append(s.evaluate(featureWeights));
            dataset.add(StatUtils.mean((double[])featureWeights), s.evaluate(featureWeights), (Comparable)((Object)model), (Comparable)names.get(j));
            localDataset.add(StatUtils.mean((double[])featureWeights), s.evaluate(featureWeights), (Comparable)((Object)model), (Comparable)names.get(j));
            for (int i = 0; i < REP; ++i) {
                b.append("\t").append(featureWeights[i]);
            }
            b.append("\n");
        }
        System.out.print(b.toString());
    }
}

