/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.generic;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.Assert;
import java.util.Arrays;
import java.util.List;

public class EndFeatures
extends AbstractFeatureManager<Object>
implements FeatureManagerNode<Object> {
    private static final long serialVersionUID = 5206582215565363768L;
    int startIx;
    int[] endStates;
    String[] names;
    int[] configStates = new int[]{0, 1};

    public void setStates(int[] config) {
        this.configStates = config;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        Assert.a(featureIndex - this.startIx < this.names.length, "Invalid feature index");
        return this.names[featureIndex - this.startIx];
    }

    @Override
    public int getNumFeatures() {
        return this.names.length;
    }

    @Override
    public void evaluateNode(InputSequence<?> seq, int pos, int state, FeatureList result) {
        int index;
        if (pos == seq.length() - 1 && (index = this.endStates[state]) != -1) {
            result.addFeature(index, 1.0);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List data) {
        this.startIx = startingIndex;
        this.endStates = new int[modelInfo.getNumStates()];
        Arrays.fill(this.endStates, -1);
        this.names = new String[this.configStates.length];
        for (int i = 0; i < this.configStates.length; ++i) {
            this.endStates[this.configStates[i]] = this.startIx + i;
            this.names[i] = "End." + modelInfo.getStateName(this.configStates[i]);
        }
    }
}

