/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.generic;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.Assert;
import calhoun.util.DenseBooleanMatrix2D;
import calhoun.util.DenseIntMatrix2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndicatorEdges
extends AbstractFeatureManager
implements FeatureManagerEdge {
    private static final long serialVersionUID = -2633500053477439285L;
    private static final Log log = LogFactory.getLog(IndicatorEdges.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    DenseIntMatrix2D transitions;
    List<String> names;

    @Override
    public String getFeatureName(int featureIndex) {
        Assert.a(featureIndex - this.startIx < this.names.size(), "Invalid feature index");
        return this.names.get(featureIndex - this.startIx);
    }

    @Override
    public int getNumFeatures() {
        return this.names.size();
    }

    public void evaluateEdge(InputSequence seq, int pos, int prevState, int state, FeatureList result) {
        int index = this.transitions.getQuick(prevState, state);
        if (index != -1) {
            result.addFeature(index, 1.0);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List data) {
        this.startIx = startingIndex;
        int nStates = modelInfo.getNumStates();
        this.transitions = new DenseIntMatrix2D(nStates, nStates);
        this.transitions.assign(-1);
        this.names = new ArrayList<String>();
        int n = 0;
        DenseBooleanMatrix2D trans = modelInfo.getLegalTransitions();
        for (int i = 0; i < nStates; ++i) {
            for (int j = 0; j < nStates; ++j) {
                if (!trans.getQuick(i, j)) continue;
                this.transitions.setQuick(i, j, this.startIx + n);
                this.names.add("Edge." + modelInfo.getStateName(i) + "-" + modelInfo.getStateName(j));
                ++n;
            }
        }
    }
}

