/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.CompositeInput;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ESTInterval13
extends AbstractFeatureManager<CompositeInput>
implements FeatureManagerNode<CompositeInput>,
FeatureManagerEdge<CompositeInput> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(ESTInterval13.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    boolean[] intergenicState;
    boolean[] plusExonState;
    boolean[] minusExonState;
    boolean[] plusIntronState;
    boolean[] minusIntronState;

    @Override
    public int getNumFeatures() {
        return 9;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        String[] types = new String[]{"exon", "intron", "Intergenic"};
        String[] evidence = new String[]{"consistent", "mixed"};
        int raw = featureIndex - this.startIx;
        if (raw < 6) {
            return "EST " + types[raw / 2] + " " + evidence[raw % 2];
        }
        String[] edge = new String[]{"acceptor", "donor", "no edge"};
        return "EST " + edge[raw - 6];
    }

    @Override
    public void evaluateNode(InputSequence<? extends CompositeInput> seq, int pos, int state, FeatureList result) {
        if (pos == seq.length() - 1) {
            return;
        }
        InputSequence<?> pest = seq.getComponent("pest");
        InputSequence<?> mest = seq.getComponent("mest");
        int plusEst = (Integer)pest.getX(pos + 1);
        int minusEst = (Integer)mest.getX(pos + 1);
        if (this.plusExonState[state] && plusEst == 1) {
            result.addFeature(this.startIx, 1.0);
        }
        if (this.minusExonState[state] && minusEst == 1) {
            result.addFeature(this.startIx, 1.0);
        }
        if (this.plusExonState[state] && plusEst == 3) {
            result.addFeature(this.startIx + 1, 1.0);
        }
        if (this.minusExonState[state] && minusEst == 3) {
            result.addFeature(this.startIx + 1, 1.0);
        }
        if (this.plusIntronState[state] && plusEst == 2) {
            result.addFeature(this.startIx + 2, 1.0);
        }
        if (this.minusIntronState[state] && minusEst == 2) {
            result.addFeature(this.startIx + 2, 1.0);
        }
        if (this.plusIntronState[state] && plusEst == 3) {
            result.addFeature(this.startIx + 3, 1.0);
        }
        if (this.minusIntronState[state] && minusEst == 3) {
            result.addFeature(this.startIx + 3, 1.0);
        }
        if (this.intergenicState[state] && (plusEst == 1 || minusEst == 1 || plusEst == 2 || minusEst == 2)) {
            result.addFeature(this.startIx + 4, 1.0);
        }
        if (this.intergenicState[state] && (plusEst == 3 || minusEst == 3)) {
            result.addFeature(this.startIx + 5, 1.0);
        }
    }

    @Override
    public void evaluateEdge(InputSequence<? extends CompositeInput> seq, int pos, int prevState, int state, FeatureList result) {
        if (pos == seq.length() - 1 || pos == 0) {
            return;
        }
        InputSequence<?> pest = seq.getComponent("pest");
        InputSequence<?> mest = seq.getComponent("mest");
        int plusE = (Integer)pest.getX(pos + 1);
        int plusEp = (Integer)pest.getX(pos);
        int minusE = (Integer)mest.getX(pos + 1);
        int minusEp = (Integer)mest.getX(pos);
        Boolean plusacc = plusEp == 2 && plusE == 1;
        Boolean plusdon = plusEp == 1 && plusE == 2;
        Boolean minusacc = minusEp == 1 && minusE == 2;
        Boolean minusdon = minusEp == 2 && minusE == 1;
        if (plusacc.booleanValue() && this.plusExonState[state] && this.plusIntronState[prevState]) {
            result.addFeature(this.startIx + 6, 1.0);
            return;
        }
        if (minusacc.booleanValue() && this.minusExonState[prevState] && this.minusIntronState[state]) {
            result.addFeature(this.startIx + 6, 1.0);
            return;
        }
        if (plusdon.booleanValue() && this.plusIntronState[state] && this.plusExonState[prevState]) {
            result.addFeature(this.startIx + 7, 1.0);
            return;
        }
        if (minusdon.booleanValue() && this.plusIntronState[prevState] && this.plusExonState[state]) {
            result.addFeature(this.startIx + 7, 1.0);
            return;
        }
        result.addFeature(this.startIx + 8, 1.0);
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends CompositeInput>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        int nStates = this.model.getNumStates();
        this.plusExonState = new boolean[nStates];
        this.plusExonState[this.model.getStateIndex((String)"exon0")] = true;
        this.plusExonState[this.model.getStateIndex((String)"exon1")] = true;
        this.plusExonState[this.model.getStateIndex((String)"exon2")] = true;
        this.minusExonState = new boolean[nStates];
        this.minusExonState[this.model.getStateIndex((String)"exon0m")] = true;
        this.minusExonState[this.model.getStateIndex((String)"exon1m")] = true;
        this.minusExonState[this.model.getStateIndex((String)"exon2m")] = true;
        this.plusIntronState = new boolean[nStates];
        this.plusIntronState[this.model.getStateIndex((String)"intron0")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron1")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron2")] = true;
        this.minusIntronState = new boolean[nStates];
        this.minusIntronState[this.model.getStateIndex((String)"intron0m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron1m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron2m")] = true;
        this.intergenicState = new boolean[nStates];
        this.intergenicState[this.model.getStateIndex((String)"intergenic")] = true;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.DENSE);
    }
}

