/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.MultipleAlignmentInputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FootprintsInterval13
extends AbstractFeatureManager<MultipleAlignmentInputSequence.MultipleAlignmentColumn>
implements FeatureManagerNode<MultipleAlignmentInputSequence.MultipleAlignmentColumn> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(FootprintsInterval13.class);
    boolean debug = log.isDebugEnabled();
    List<String> speciesNames;
    int startIx;
    ModelManager model;
    KmerHasher h = new KmerHasher(KmerHasher.ACGTN, 1);
    int maxSeqLength;
    int nFeatures = -1;
    Boolean[] isStateCoding;
    Boolean[] isStateIntronic;
    Boolean[] isStateIntergenic;

    @Override
    public int getNumFeatures() {
        return this.nFeatures;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        String[] type = new String[]{"intergenic", "exonic", "intronic"};
        int raw = featureIndex - this.startIx;
        Assert.a(raw < this.nFeatures);
        if (this.speciesNames == null) {
            return "Species " + (raw / 3 + 1) + " " + type[raw % 3] + " footprint";
        }
        return this.speciesNames.get(raw / 3 + 1) + " " + type[raw % 3] + " footprint";
    }

    @Override
    public void evaluateNode(InputSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> seq, int pos, int state, FeatureList result) {
        MultipleAlignmentInputSequence.MultipleAlignmentColumn mac = seq.getX(pos);
        for (int species = 1; species < mac.numSpecies(); ++species) {
            if (mac.nucleotide(species) == '-') continue;
            if (this.isStateIntergenic[state].booleanValue()) {
                result.addFeature(this.startIx + ((species - 1) * 3 + 0), 1.0);
            }
            if (this.isStateCoding[state].booleanValue()) {
                result.addFeature(this.startIx + ((species - 1) * 3 + 1), 1.0);
            }
            if (!this.isStateIntronic[state].booleanValue()) continue;
            result.addFeature(this.startIx + ((species - 1) * 3 + 2), 1.0);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn>> data) {
        int j;
        TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> seq = data.get(0);
        this.speciesNames = seq.getX(0).getMultipleAlignment().getSpeciesNames();
        this.startIx = startingIndex;
        this.model = modelInfo;
        int nStates = this.model.getNumStates();
        this.nFeatures = 3 * (data.get(0).getX(0).numSpecies() - 1);
        this.isStateCoding = new Boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.isStateCoding[j] = false;
        }
        this.isStateCoding[1] = true;
        this.isStateCoding[2] = true;
        this.isStateCoding[3] = true;
        this.isStateCoding[7] = true;
        this.isStateCoding[8] = true;
        this.isStateCoding[9] = true;
        this.isStateIntronic = new Boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.isStateIntronic[j] = false;
        }
        this.isStateIntronic[4] = true;
        this.isStateIntronic[5] = true;
        this.isStateIntronic[6] = true;
        this.isStateIntronic[10] = true;
        this.isStateIntronic[11] = true;
        this.isStateIntronic[12] = true;
        this.isStateIntergenic = new Boolean[nStates];
        for (j = 0; j < nStates; ++j) {
            this.isStateIntergenic[j] = false;
        }
        this.isStateIntergenic[0] = true;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.DENSE);
    }
}

