/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.interval13.Interval13Tools;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeneConstraintsInterval13
extends AbstractFeatureManager<Character>
implements FeatureManagerEdge<Character>,
FeatureManagerNode<Character> {
    private static final Log log = LogFactory.getLog(GeneConstraintsInterval13.class);
    private static final long serialVersionUID = 3041359216265032511L;

    @Override
    public String getFeatureName(int featureIndex) {
        return "Gene constraints for the model Interval13";
    }

    @Override
    public int getNumFeatures() {
        return 0;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        Interval13Tools.verify(modelInfo);
    }

    @Override
    public void evaluateEdge(InputSequence<? extends Character> seq, int pos, int prevState, int state, FeatureList result) {
        boolean valid = true;
        switch (Interval13Tools.edgeConstraints[prevState * Interval13Tools.numStates + state]) {
            case NONE: {
                break;
            }
            case NEVER: {
                Assert.a(false);
                break;
            }
            case PSTART: {
                int eind = Interval13Tools.check012(state - 1);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.startConstraintPlus(seq, pos);
                break;
            }
            case PDON: {
                int iind = Interval13Tools.check012(state - 4);
                int eind = Interval13Tools.check012(prevState - 1);
                if ((pos - eind + iind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.donorConstraintPlus(seq, pos);
                break;
            }
            case PACC: {
                int iind = Interval13Tools.check012(prevState - 4);
                int eind = Interval13Tools.check012(state - 1);
                if ((pos - eind + iind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.acceptorConstraintPlus(seq, pos);
                break;
            }
            case PSTOP: {
                int eind = Interval13Tools.check012(prevState - 1);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.stopEdgeConstraintPlus(seq, pos);
                break;
            }
            case MSTART: {
                int eind = Interval13Tools.check012(prevState - 7);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.startConstraintMinus(seq, pos);
                break;
            }
            case MDON: {
                int iind = Interval13Tools.check012(prevState - 10);
                int eind = Interval13Tools.check012(state - 7);
                if ((pos - eind - iind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.donorConstraintMinus(seq, pos);
                break;
            }
            case MACC: {
                int iind = Interval13Tools.check012(state - 10);
                int eind = Interval13Tools.check012(prevState - 7);
                if ((pos - eind - iind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.acceptorConstraintMinus(seq, pos);
                break;
            }
            case MSTOP: {
                int eind = Interval13Tools.check012(state - 7);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.stopEdgeConstraintMinus(seq, pos);
                break;
            }
            case PCODE: {
                int eind = Interval13Tools.check012(state - 1);
                if ((pos - eind) % 3 != 2) break;
                valid = !this.stopNodeConstraintPlus(seq, pos);
                break;
            }
            case MCODE: {
                int eind = Interval13Tools.check012(state - 7);
                if ((pos - eind) % 3 != 0) break;
                valid = !this.stopNodeConstraintMinus(seq, pos);
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        if (!valid) {
            result.invalidate();
        }
    }

    @Override
    public void evaluateNode(InputSequence<? extends Character> seq, int pos, int state, FeatureList result) {
        boolean valid = true;
        switch (Interval13Tools.nodeConstraints[state]) {
            case NONE: {
                break;
            }
            case NEVER: {
                Assert.a(false);
                break;
            }
            case PCODE: {
                int eind = Interval13Tools.check012(state - 1);
                if ((pos - eind) % 3 != 2) break;
                valid = !this.stopNodeConstraintPlus(seq, pos);
                break;
            }
            case MCODE: {
                int eind = Interval13Tools.check012(state - 7);
                if ((pos - eind) % 3 != 0) break;
                valid = !this.stopNodeConstraintMinus(seq, pos);
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        if (!valid) {
            result.invalidate();
        }
    }

    private boolean startConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        return seq.length() > pos + 2 && seq.getX(pos).charValue() == 'A' && seq.getX(pos + 1).charValue() == 'T' && seq.getX(pos + 2).charValue() == 'G';
    }

    private boolean startConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        return pos >= 3 && seq.getX(pos - 3).charValue() == 'C' && seq.getX(pos - 2).charValue() == 'A' && seq.getX(pos - 1).charValue() == 'T';
    }

    private boolean donorConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        return seq.length() > pos + 1 && seq.getX(pos).charValue() == 'G' && (seq.getX(pos + 1).charValue() == 'T' || seq.getX(pos + 1).charValue() == 'C');
    }

    private boolean donorConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        boolean ret = pos >= 2 && (seq.getX(pos - 2).charValue() == 'A' || seq.getX(pos - 2).charValue() == 'G') && seq.getX(pos - 1).charValue() == 'C';
        return ret;
    }

    private boolean acceptorConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        return pos > 1 && seq.getX(pos - 2).charValue() == 'A' && seq.getX(pos - 1).charValue() == 'G';
    }

    private boolean acceptorConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        boolean ret = seq.length() > pos + 1 && seq.getX(pos).charValue() == 'C' && seq.getX(pos + 1).charValue() == 'T';
        return ret;
    }

    private boolean stopEdgeConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        if (pos < seq.length() - 2 && seq.getX(pos).charValue() == 'T') {
            return seq.getX(pos + 1).charValue() == 'A' && (seq.getX(pos + 2).charValue() == 'G' || seq.getX(pos + 2).charValue() == 'A') || seq.getX(pos + 1).charValue() == 'G' && seq.getX(pos + 2).charValue() == 'A';
        }
        return false;
    }

    private boolean stopEdgeConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        if (pos >= 3 && seq.getX(pos - 1).charValue() == 'A') {
            boolean ret = seq.getX(pos - 2).charValue() == 'T' && (seq.getX(pos - 3).charValue() == 'C' || seq.getX(pos - 3).charValue() == 'T') || seq.getX(pos - 2).charValue() == 'C' && seq.getX(pos - 3).charValue() == 'T';
            return ret;
        }
        return false;
    }

    private boolean stopNodeConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        if (pos >= 2 && seq.getX(pos - 2).charValue() == 'T') {
            return seq.getX(pos - 1).charValue() == 'A' && (seq.getX(pos).charValue() == 'G' || seq.getX(pos).charValue() == 'A') || seq.getX(pos - 1).charValue() == 'G' && seq.getX(pos).charValue() == 'A';
        }
        return false;
    }

    private boolean stopNodeConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        if (pos < seq.length() - 2 && seq.getX(pos + 2).charValue() == 'A') {
            boolean ret = seq.getX(pos + 1).charValue() == 'T' && (seq.getX(pos).charValue() == 'C' || seq.getX(pos).charValue() == 'T') || seq.getX(pos + 1).charValue() == 'C' && seq.getX(pos).charValue() == 'T';
            return ret;
        }
        return false;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

