/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval13;

import calhoun.analysis.crf.ModelManager;
import calhoun.util.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Interval13Tools {
    private static final Log log;
    protected static Constraint[] edgeConstraints;
    protected static Constraint[] nodeConstraints;
    static int numStates;

    protected static int check012(int x) {
        Assert.a(x >= 0);
        Assert.a(x <= 2);
        return x;
    }

    protected static void verify(ModelManager modelInfo) {
        Assert.a(modelInfo.getNumStates() == 13);
        Assert.a(modelInfo.getStateName(0).equals("intergenic"));
        Assert.a(modelInfo.getStateName(1).equals("exon0"));
        Assert.a(modelInfo.getStateName(2).equals("exon1"));
        Assert.a(modelInfo.getStateName(3).equals("exon2"));
        Assert.a(modelInfo.getStateName(4).equals("intron0"));
        Assert.a(modelInfo.getStateName(5).equals("intron1"));
        Assert.a(modelInfo.getStateName(6).equals("intron2"));
        Assert.a(modelInfo.getStateName(7).equals("exon0m"));
        Assert.a(modelInfo.getStateName(8).equals("exon1m"));
        Assert.a(modelInfo.getStateName(9).equals("exon2m"));
        Assert.a(modelInfo.getStateName(10).equals("intron0m"));
        Assert.a(modelInfo.getStateName(11).equals("intron1m"));
        Assert.a(modelInfo.getStateName(12).equals("intron2m"));
    }

    static {
        int j;
        int i;
        log = LogFactory.getLog(Interval13Tools.class);
        log.debug((Object)"Setting up constraints in Interval13Tools");
        numStates = 13;
        nodeConstraints = new Constraint[numStates];
        for (int j2 = 0; j2 < numStates; ++j2) {
            Interval13Tools.nodeConstraints[j2] = Constraint.NONE;
        }
        Interval13Tools.nodeConstraints[1] = Constraint.PCODE;
        Interval13Tools.nodeConstraints[2] = Constraint.PCODE;
        Interval13Tools.nodeConstraints[3] = Constraint.PCODE;
        Interval13Tools.nodeConstraints[7] = Constraint.MCODE;
        Interval13Tools.nodeConstraints[8] = Constraint.MCODE;
        Interval13Tools.nodeConstraints[9] = Constraint.MCODE;
        log.debug((Object)"The node constraints are as follows:");
        for (i = 0; i < 13; ++i) {
            log.debug((Object)("  " + i + "  --  " + (Object)((Object)nodeConstraints[i])));
        }
        edgeConstraints = new Constraint[numStates * numStates];
        for (i = 0; i < numStates; ++i) {
            for (j = 0; j < numStates; ++j) {
                Interval13Tools.edgeConstraints[i * Interval13Tools.numStates + j] = Constraint.NEVER;
            }
        }
        for (i = 0; i < numStates; ++i) {
            Interval13Tools.edgeConstraints[i * Interval13Tools.numStates + i] = Constraint.NONE;
        }
        for (i = 0; i < 3; ++i) {
            Interval13Tools.edgeConstraints[0 * Interval13Tools.numStates + (i + 1)] = Constraint.PSTART;
            Interval13Tools.edgeConstraints[(i + 1) * Interval13Tools.numStates + 0] = Constraint.PSTOP;
            Interval13Tools.edgeConstraints[(i + 1) * Interval13Tools.numStates + (i + 1)] = Constraint.PCODE;
            Interval13Tools.edgeConstraints[0 * Interval13Tools.numStates + (i + 7)] = Constraint.MSTOP;
            Interval13Tools.edgeConstraints[(i + 7) * Interval13Tools.numStates + 0] = Constraint.MSTART;
            Interval13Tools.edgeConstraints[(i + 7) * Interval13Tools.numStates + (i + 7)] = Constraint.MCODE;
            for (j = 0; j < 3; ++j) {
                Interval13Tools.edgeConstraints[(i + 1) * Interval13Tools.numStates + (j + 4)] = Constraint.PDON;
                Interval13Tools.edgeConstraints[(i + 4) * Interval13Tools.numStates + (j + 1)] = Constraint.PACC;
                Interval13Tools.edgeConstraints[(i + 10) * Interval13Tools.numStates + (j + 7)] = Constraint.MDON;
                Interval13Tools.edgeConstraints[(i + 7) * Interval13Tools.numStates + (j + 10)] = Constraint.MACC;
            }
        }
        log.debug((Object)"The transition constraints are as follows:");
        for (i = 0; i < 13; ++i) {
            String s = "";
            for (int j3 = 0; j3 < 13; ++j3) {
                s = s + (Object)((Object)edgeConstraints[i * numStates + j3]) + "\t";
            }
            log.debug((Object)s);
        }
    }

    protected static enum Constraint {
        NONE,
        NEVER,
        PSTART,
        PDON,
        PACC,
        PSTOP,
        MSTART,
        MDON,
        MACC,
        MSTOP,
        PCODE,
        MCODE;

    }
}

