/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval29;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.interval29.Interval29Tools;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.List;

public class GeneConstraintsInterval29
extends AbstractFeatureManager<Character>
implements FeatureManagerEdge<Character>,
FeatureManagerNode<Character> {
    private static final long serialVersionUID = 3041359216265032511L;

    @Override
    public String getFeatureName(int featureIndex) {
        return "Gene constraints for the model Interval29";
    }

    @Override
    public int getNumFeatures() {
        return 0;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        Interval29Tools.verify(modelInfo);
    }

    @Override
    public void evaluateEdge(InputSequence<? extends Character> seq, int pos, int prevState, int state, FeatureList result) {
        boolean valid = true;
        switch (Interval29Tools.edgeConstraints[prevState * Interval29Tools.numStates + state]) {
            case NONE: {
                break;
            }
            case NEVER: {
                Assert.a(false);
                break;
            }
            case PSTART: {
                int eind = Interval29Tools.check012(state - 1);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.startConstraintPlus(seq, pos);
                break;
            }
            case PDON: {
                int iind = Interval29Tools.check012(state - 15);
                int eind = Interval29Tools.check012(prevState - 1);
                if ((pos - eind + iind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = pos < 0 || this.donorConstraintPlus(seq, pos);
                break;
            }
            case PACC: {
                int eind = Interval29Tools.check012(state - 18);
                int iind = Interval29Tools.check012(prevState - 4);
                if ((pos + 2 - eind + iind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = pos + 2 >= seq.length() || this.acceptorConstraintPlus(seq, pos + 2);
                break;
            }
            case PSTOP: {
                int eind = Interval29Tools.check012(prevState - 1);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.stopEdgeConstraintPlus(seq, pos);
                break;
            }
            case MSTART: {
                int eind = Interval29Tools.check012(prevState - 7);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.startConstraintMinus(seq, pos);
                break;
            }
            case MDON: {
                int eind = Interval29Tools.check012(state - 26);
                int iind = Interval29Tools.check012(prevState - 10);
                if ((pos + 2 - eind - iind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = pos + 2 >= seq.length() || this.donorConstraintMinus(seq, pos + 2);
                break;
            }
            case MACC: {
                int iind = Interval29Tools.check012(state - 23);
                int eind = Interval29Tools.check012(prevState - 7);
                if ((pos - eind - iind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = pos < 0 || this.acceptorConstraintMinus(seq, pos);
                break;
            }
            case MSTOP: {
                int eind = Interval29Tools.check012(state - 7);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.stopEdgeConstraintMinus(seq, pos);
                break;
            }
            case PCODE: {
                int eind = Interval29Tools.check012(state - 1);
                if ((pos - eind) % 3 != 2) break;
                valid = !this.stopNodeConstraintPlus(seq, pos);
                break;
            }
            case MCODE: {
                int eind = Interval29Tools.check012(state - 7);
                if ((pos - eind) % 3 != 0) break;
                valid = !this.stopNodeConstraintMinus(seq, pos);
                break;
            }
            case PKEEPE: {
                int eind1 = Interval29Tools.check012(prevState - 18);
                int eind2 = Interval29Tools.check012(state - 1);
                if (eind1 != eind2) {
                    valid = false;
                    break;
                }
                valid = this.acceptorConstraintPlus(seq, pos);
                break;
            }
            case PKEEPI: {
                int iind1 = Interval29Tools.check012(prevState - 15);
                int iind2 = Interval29Tools.check012(state - 4);
                if (iind1 != iind2) {
                    valid = false;
                    break;
                }
                valid = pos - 2 < 0 || this.donorConstraintPlus(seq, pos - 2);
                break;
            }
            case MKEEPE: {
                int eind1 = Interval29Tools.check012(prevState - 26);
                int eind2 = Interval29Tools.check012(state - 7);
                if (eind1 != eind2) {
                    valid = false;
                    break;
                }
                valid = this.donorConstraintMinus(seq, pos);
                break;
            }
            case MKEEPI: {
                int iind1 = Interval29Tools.check012(prevState - 23);
                int iind2 = Interval29Tools.check012(state - 10);
                if (iind1 != iind2) {
                    valid = false;
                    break;
                }
                valid = pos - 2 < 0 || this.acceptorConstraintMinus(seq, pos - 2);
                break;
            }
            case PSTOPPED: {
                valid = pos - 2 < 0 || this.stopEdgeConstraintPlus(seq, pos - 2);
                break;
            }
            case MSTARTED: {
                valid = pos - 2 < 0 || this.startConstraintMinus(seq, pos - 2);
                break;
            }
            case PWILLSTART: {
                valid = pos + 2 >= seq.length() || this.startConstraintPlus(seq, pos + 2);
                break;
            }
            case MWILLSTOP: {
                valid = pos + 2 >= seq.length() || this.stopEdgeConstraintMinus(seq, pos + 2);
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        if (!valid) {
            result.invalidate();
        }
    }

    @Override
    public void evaluateNode(InputSequence<? extends Character> seq, int pos, int state, FeatureList result) {
        boolean valid = true;
        switch (Interval29Tools.nodeConstraints[state]) {
            case NONE: {
                break;
            }
            case NEVER: {
                Assert.a(false);
                break;
            }
            case PCODE: {
                int eind = Interval29Tools.check012(state - 1);
                if ((pos - eind) % 3 != 2) break;
                valid = !this.stopNodeConstraintPlus(seq, pos);
                break;
            }
            case MCODE: {
                int eind = Interval29Tools.check012(state - 7);
                if ((pos - eind) % 3 != 0) break;
                valid = !this.stopNodeConstraintMinus(seq, pos);
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        if (!valid) {
            result.invalidate();
        }
    }

    private boolean startConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        return seq.length() > pos + 2 && seq.getX(pos).charValue() == 'A' && seq.getX(pos + 1).charValue() == 'T' && seq.getX(pos + 2).charValue() == 'G';
    }

    private boolean startConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        return pos >= 3 && seq.getX(pos - 3).charValue() == 'C' && seq.getX(pos - 2).charValue() == 'A' && seq.getX(pos - 1).charValue() == 'T';
    }

    private boolean donorConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        return seq.length() > pos + 1 && seq.getX(pos).charValue() == 'G' && (seq.getX(pos + 1).charValue() == 'T' || seq.getX(pos + 1).charValue() == 'C');
    }

    private boolean donorConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        return pos >= 2 && (seq.getX(pos - 2).charValue() == 'A' || seq.getX(pos - 2).charValue() == 'G') && seq.getX(pos - 1).charValue() == 'C';
    }

    private boolean acceptorConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        return pos > 1 && seq.getX(pos - 2).charValue() == 'A' && seq.getX(pos - 1).charValue() == 'G';
    }

    private boolean acceptorConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        return seq.length() > pos + 1 && seq.getX(pos).charValue() == 'C' && seq.getX(pos + 1).charValue() == 'T';
    }

    private boolean stopEdgeConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        if (pos < seq.length() - 2 && seq.getX(pos).charValue() == 'T') {
            return seq.getX(pos + 1).charValue() == 'A' && (seq.getX(pos + 2).charValue() == 'G' || seq.getX(pos + 2).charValue() == 'A') || seq.getX(pos + 1).charValue() == 'G' && seq.getX(pos + 2).charValue() == 'A';
        }
        return false;
    }

    private boolean stopEdgeConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        if (pos >= 3 && seq.getX(pos - 1).charValue() == 'A') {
            return seq.getX(pos - 2).charValue() == 'T' && (seq.getX(pos - 3).charValue() == 'C' || seq.getX(pos - 3).charValue() == 'T') || seq.getX(pos - 2).charValue() == 'C' && seq.getX(pos - 3).charValue() == 'T';
        }
        return false;
    }

    private boolean stopNodeConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        if (pos >= 2 && seq.getX(pos - 2).charValue() == 'T') {
            return seq.getX(pos - 1).charValue() == 'A' && (seq.getX(pos).charValue() == 'G' || seq.getX(pos).charValue() == 'A') || seq.getX(pos - 1).charValue() == 'G' && seq.getX(pos).charValue() == 'A';
        }
        return false;
    }

    private boolean stopNodeConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        if (pos < seq.length() - 2 && seq.getX(pos + 2).charValue() == 'A') {
            return seq.getX(pos + 1).charValue() == 'T' && (seq.getX(pos).charValue() == 'C' || seq.getX(pos).charValue() == 'T') || seq.getX(pos + 1).charValue() == 'C' && seq.getX(pos).charValue() == 'T';
        }
        return false;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

