/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval29;

import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Interval29Tools {
    private static final Log log;
    protected static Constraint[] edgeConstraints;
    protected static Constraint[] nodeConstraints;
    static int numStates;

    protected static int check012(int x) {
        Assert.a(x >= 0, "x is " + x);
        Assert.a(x <= 2, "x is " + x);
        return x;
    }

    protected static void verify(ModelManager modelInfo) {
        Assert.a(modelInfo.getNumStates() == 29);
        Assert.a(modelInfo.getStateName(0).equals("intergenic"));
        Assert.a(modelInfo.getStateName(1).equals("exon0"));
        Assert.a(modelInfo.getStateName(2).equals("exon1"));
        Assert.a(modelInfo.getStateName(3).equals("exon2"));
        Assert.a(modelInfo.getStateName(4).equals("intron0"));
        Assert.a(modelInfo.getStateName(5).equals("intron1"));
        Assert.a(modelInfo.getStateName(6).equals("intron2"));
        Assert.a(modelInfo.getStateName(7).equals("exon0m"));
        Assert.a(modelInfo.getStateName(8).equals("exon1m"));
        Assert.a(modelInfo.getStateName(9).equals("exon2m"));
        Assert.a(modelInfo.getStateName(10).equals("intron0m"));
        Assert.a(modelInfo.getStateName(11).equals("intron1m"));
        Assert.a(modelInfo.getStateName(12).equals("intron2m"));
    }

    protected static List<TrainingSequence<?>> checkValidTransitions(List<? extends TrainingSequence<?>> data) {
        ArrayList goodData = new ArrayList();
        for (TrainingSequence<?> seq : data) {
            boolean validSequence = true;
            for (int pos = 1; pos < seq.length(); ++pos) {
                int state = seq.getY(pos);
                int prevState = seq.getY(pos - 1);
                if (edgeConstraints[prevState * numStates + state] != Constraint.NEVER) continue;
                System.out.println("bad: " + prevState + " " + state);
                validSequence = false;
                break;
            }
            if (!validSequence) continue;
            goodData.add(seq);
        }
        return goodData;
    }

    static {
        int j;
        int i;
        log = LogFactory.getLog(Interval29Tools.class);
        log.debug((Object)"Setting up constraints in Interval29Tools");
        numStates = 29;
        nodeConstraints = new Constraint[numStates];
        for (int j2 = 0; j2 < numStates; ++j2) {
            Interval29Tools.nodeConstraints[j2] = Constraint.NONE;
        }
        Interval29Tools.nodeConstraints[1] = Constraint.PCODE;
        Interval29Tools.nodeConstraints[2] = Constraint.PCODE;
        Interval29Tools.nodeConstraints[3] = Constraint.PCODE;
        Interval29Tools.nodeConstraints[7] = Constraint.MCODE;
        Interval29Tools.nodeConstraints[8] = Constraint.MCODE;
        Interval29Tools.nodeConstraints[9] = Constraint.MCODE;
        log.debug((Object)"The node constraints are as follows:");
        for (i = 0; i < numStates; ++i) {
            log.debug((Object)("  " + i + "  --  " + (Object)((Object)nodeConstraints[i])));
        }
        edgeConstraints = new Constraint[numStates * numStates];
        for (i = 0; i < numStates; ++i) {
            for (j = 0; j < numStates; ++j) {
                Interval29Tools.edgeConstraints[i * Interval29Tools.numStates + j] = Constraint.NEVER;
            }
        }
        for (i = 0; i < numStates; ++i) {
            Interval29Tools.edgeConstraints[i * Interval29Tools.numStates + i] = Constraint.NONE;
        }
        Interval29Tools.edgeConstraints[14 * Interval29Tools.numStates + 0] = Constraint.PSTOPPED;
        Interval29Tools.edgeConstraints[22 * Interval29Tools.numStates + 0] = Constraint.MSTARTED;
        for (i = 0; i < 3; ++i) {
            Interval29Tools.edgeConstraints[0 * Interval29Tools.numStates + (i + 13)] = Constraint.PWILLSTART;
            Interval29Tools.edgeConstraints[0 * Interval29Tools.numStates + (i + 21)] = Constraint.MWILLSTOP;
            Interval29Tools.edgeConstraints[13 * Interval29Tools.numStates + (i + 1)] = Constraint.PSTART;
            Interval29Tools.edgeConstraints[21 * Interval29Tools.numStates + (i + 7)] = Constraint.MSTOP;
            Interval29Tools.edgeConstraints[(i + 1) * Interval29Tools.numStates + 14] = Constraint.PSTOP;
            Interval29Tools.edgeConstraints[(i + 7) * Interval29Tools.numStates + 22] = Constraint.MSTART;
            Interval29Tools.edgeConstraints[(i + 1) * Interval29Tools.numStates + (i + 1)] = Constraint.PCODE;
            Interval29Tools.edgeConstraints[(i + 7) * Interval29Tools.numStates + (i + 7)] = Constraint.MCODE;
            for (j = 0; j < 3; ++j) {
                Interval29Tools.edgeConstraints[(i + 1) * Interval29Tools.numStates + (j + 15)] = Constraint.PDON;
                Interval29Tools.edgeConstraints[(i + 4) * Interval29Tools.numStates + (j + 18)] = Constraint.PACC;
                Interval29Tools.edgeConstraints[(i + 7) * Interval29Tools.numStates + (j + 23)] = Constraint.MACC;
                Interval29Tools.edgeConstraints[(i + 10) * Interval29Tools.numStates + (j + 26)] = Constraint.MDON;
            }
            Interval29Tools.edgeConstraints[(i + 15) * Interval29Tools.numStates + (i + 4)] = Constraint.PKEEPI;
            Interval29Tools.edgeConstraints[(i + 18) * Interval29Tools.numStates + (i + 1)] = Constraint.PKEEPE;
            Interval29Tools.edgeConstraints[(i + 23) * Interval29Tools.numStates + (i + 10)] = Constraint.MKEEPI;
            Interval29Tools.edgeConstraints[(i + 26) * Interval29Tools.numStates + (i + 7)] = Constraint.MKEEPE;
        }
    }

    protected static enum Constraint {
        NONE,
        NEVER,
        PSTART,
        PDON,
        PACC,
        PSTOP,
        MSTART,
        MDON,
        MACC,
        MSTOP,
        PCODE,
        MCODE,
        PKEEPE,
        PKEEPI,
        MKEEPE,
        MKEEPI,
        PSTOPPED,
        MSTARTED,
        PWILLSTART,
        MWILLSTOP;

    }
}

