/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval29;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.interval29.Interval29Tools;
import calhoun.analysis.crf.features.supporting.LogProbLookup;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.List;

public abstract class ReferenceBasePredictorInterval29Base
extends AbstractFeatureManager<Character> {
    private static final long serialVersionUID = 8194502006226691957L;
    ModelManager model;
    int startIx;
    boolean multipleFeatures = false;
    double pseudoCounts;
    int lookback;
    LogProbLookup intron;
    LogProbLookup intergenic;
    LogProbLookup[] exonic;

    @Override
    public String getFeatureName(int featureIndex) {
        if (this.multipleFeatures) {
            int feat = featureIndex - this.startIx;
            String table = "";
            switch (feat) {
                case 0: {
                    table = "intergenic";
                    break;
                }
                case 1: {
                    table = "exon";
                    break;
                }
                case 2: {
                    table = "intron";
                    break;
                }
                case 3: {
                    table = "minus exon";
                    break;
                }
                case 4: {
                    table = "minus intron";
                    break;
                }
                default: {
                    Assert.a(false);
                }
            }
            return "referenceBasePredictorInterval29 " + table;
        }
        return "referenceBasePredictorInterval29";
    }

    @Override
    public int getNumFeatures() {
        return this.multipleFeatures ? 5 : 1;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        Interval29Tools.verify(modelInfo);
        this.pseudoCounts = 1.0;
        this.lookback = 3;
        this.exonic = new LogProbLookup[3];
        for (int j = 0; j < 3; ++j) {
            this.exonic[j] = new LogProbLookup(this.lookback, this.pseudoCounts);
        }
        this.intron = new LogProbLookup(this.lookback, this.pseudoCounts);
        this.intergenic = new LogProbLookup(this.lookback, this.pseudoCounts);
        for (TrainingSequence<? extends Character> trainingSequence : data) {
            block9: for (int pos = 0; pos < trainingSequence.length(); ++pos) {
                int state = trainingSequence.getY(pos);
                switch (state) {
                    case 0: 
                    case 13: 
                    case 14: 
                    case 21: 
                    case 22: {
                        this.intergenic.increment(trainingSequence, pos, true);
                        this.intergenic.increment(trainingSequence, pos, false);
                        continue block9;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.exonic[((pos - state + 1) % 3 + 3) % 3].increment(trainingSequence, pos, true);
                        continue block9;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        this.intron.increment(trainingSequence, pos, true);
                        continue block9;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        this.exonic[((-pos + state + 1) % 3 + 3) % 3].increment(trainingSequence, pos, false);
                        continue block9;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: {
                        this.intron.increment(trainingSequence, pos, false);
                        continue block9;
                    }
                    default: {
                        Assert.a(false);
                    }
                }
            }
        }
        for (int j = 0; j < 3; ++j) {
            this.exonic[j].finalize();
        }
        this.intron.finalize();
        this.intergenic.finalize();
    }

    public void evaluateNode(InputSequence<? extends Character> seq, int pos, int state, FeatureList result) {
        double evaluation = 0.0;
        int indexOffset = Integer.MIN_VALUE;
        switch (state) {
            case 0: 
            case 13: 
            case 14: 
            case 21: 
            case 22: {
                evaluation = this.intergenic.lookup(seq, pos, true);
                indexOffset = 0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int phase = ((pos - state + 1) % 3 + 3) % 3;
                evaluation = this.exonic[phase].lookup(seq, pos, true);
                indexOffset = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                evaluation = this.intron.lookup(seq, pos, true);
                indexOffset = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                int phase = ((-pos + state + 1) % 3 + 3) % 3;
                evaluation = this.exonic[phase].lookup(seq, pos, false);
                indexOffset = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                evaluation = this.intron.lookup(seq, pos, false);
                indexOffset = 4;
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        result.addFeature(this.startIx + (this.multipleFeatures ? indexOffset : 0), evaluation);
    }

    public boolean isMultipleFeatures() {
        return this.multipleFeatures;
    }

    public void setMultipleFeatures(boolean weightPerState) {
        this.multipleFeatures = weightPerState;
    }
}

